/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae;

import com.mojang.logging.LogUtils;
import lu.kolja.expandedae.client.ExpandedaeClient;
import lu.kolja.expandedae.datagen.conditionals.ModNotLoadedCondition;
import lu.kolja.expandedae.definition.ExpBlockEntities;
import lu.kolja.expandedae.definition.ExpBlocks;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.definition.ExpMenus;
import lu.kolja.expandedae.definition.ExpUpgrades;
import lu.kolja.expandedae.xmod.XMod;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="expandedae")
public class Expandedae {
    public static final String MODID = "expandedae";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Expandedae(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ExpBlocks.init();
        ExpItems.init();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(event -> {
            event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((IConditionSerializer)ModNotLoadedCondition.Serializer.INSTANCE));
            if (event.getRegistryKey().equals((Object)Registries.f_256747_)) {
                ExpBlocks.getBlocks().forEach(def -> {
                    ForgeRegistries.BLOCKS.register(def.id(), (Object)def.block());
                    ForgeRegistries.ITEMS.register(def.id(), (Object)def.m_5456_());
                });
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                ExpItems.getItems().forEach(i -> ForgeRegistries.ITEMS.register(i.id(), (Object)i.m_5456_()));
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256922_)) {
                ExpBlockEntities.getBlockEntityTypes().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).register(arg_0, arg_1));
            }
            if (event.getRegistryKey().equals((Object)Registries.f_256798_)) {
                ExpMenus.getMenuTypes().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.MENU_TYPES).register(arg_0, arg_1));
            }
        });
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.register((Object)ExpandedaeClient.INSTANCE);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new XMod();
        new ExpUpgrades(event);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

