/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtstoragedrawers.data;

import com.gregtechceu.gtstoragedrawers.DrawerTypes;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "gtstoragedrawers", helper);
    }

    protected void registerStatesAndModels() {
        for (DrawerTypes type : DrawerTypes.values()) {
            this.registerType(type);
        }
    }

    void registerType(DrawerTypes type) {
        BlockModelBuilder blockTrim = (BlockModelBuilder)this.models().cubeAll(type.getTrimModelName(), this.modLoc(type.getTextureName("side")));
        this.simpleBlock((Block)type.getData().blockTrim.get(), (ModelFile)blockTrim);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockFull1.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_1")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 1, false);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockFull2.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_2")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 2, false);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockFull4.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_4")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 4, false);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockHalf1.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_1")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side_h")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 1, true);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockHalf2.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_2")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side_h")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 2, true);
        this.standardDrawer(type, (BlockStandardDrawers)type.getData().blockHalf4.get(), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("front_4")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side_h")), new ResourceLocation("gtstoragedrawers", type.getTextureName("side")), new ResourceLocation("gtstoragedrawers", type.getTextureName("trim")), 4, true);
    }

    void standardDrawer(DrawerTypes type, BlockStandardDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation trim, int size, boolean half) {
        this.standardDrawer(type, block, side, front, side, side, trim, size, half);
    }

    void standardDrawer(DrawerTypes type, BlockStandardDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation top, ResourceLocation back, ResourceLocation trim, int size, boolean half) {
        String parentType = half ? "half" : "full";
        ResourceLocation parent = new ResourceLocation("storagedrawers", "block/" + parentType + "_drawers_orientable");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(type.getDrawerModelName(size, half), parent)).texture("particle", front)).texture("east", side)).texture("west", side)).texture("north", front)).texture("up", top)).texture("down", top)).texture("south", back)).texture("trim", trim);
        this.drawerState(block, (ModelFile)model);
    }

    void drawerState(BlockStandardDrawers block, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 90, false)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 180, false)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 270, false)});
    }
}

