/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.textfield;

import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.text.FontRenderHelper;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.utils.Point;
import brachy.modularui.utils.PointF;
import brachy.modularui.widgets.textfield.TextFieldHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class TextFieldRenderer
extends TextRenderer {
    protected final TextFieldHandler handler;
    protected int markedColor = -13667672;
    protected int cursorColor = -1;
    protected boolean renderCursor = false;

    public TextFieldRenderer(TextFieldHandler handler) {
        this.handler = handler;
    }

    public void toggleCursor() {
        this.renderCursor = !this.renderCursor;
    }

    public void setCursor(boolean active) {
        this.renderCursor = active;
    }

    @Override
    protected void drawMeasuredLines(GuiGraphics graphics, List<TextRenderer.Line> measuredLines) {
        this.drawMarked(graphics, measuredLines);
        super.drawMeasuredLines(graphics, measuredLines);
        if (this.renderCursor) {
            Point main = this.handler.getMainCursor();
            PointF start = this.getPosOf(measuredLines, main);
            if (this.handler.getText().get(main.y).isEmpty()) {
                start.x += 0.7f;
            }
            this.drawCursor(graphics, start.x, start.y);
        }
    }

    @Override
    public List<FormattedCharSequence> wrapLine(Component line) {
        return Collections.singletonList(line.m_7532_());
    }

    protected void drawMarked(GuiGraphics graphics, List<TextRenderer.Line> measuredLines) {
        if (!this.simulate && this.handler.hasTextMarked()) {
            PointF start = this.getPosOf(measuredLines, this.handler.getStartCursor());
            PointF end = this.getPosOf(measuredLines, this.handler.getEndCursor());
            if (start.y == end.y) {
                this.drawMarked(graphics, start.y, start.x, end.x);
            } else {
                int min = this.handler.getStartCursor().y;
                int max = this.handler.getEndCursor().y;
                TextRenderer.Line line = measuredLines.get(min);
                int startX = this.getStartX(line.width());
                this.drawMarked(graphics, start.y, start.x, (float)startX + line.width());
                start.y += this.getFontHeight();
                if (max - min > 1) {
                    for (int i = min + 1; i < max; ++i) {
                        line = measuredLines.get(i);
                        startX = this.getStartX(line.width());
                        this.drawMarked(graphics, start.y, startX, (float)startX + line.width());
                        start.y += this.getFontHeight();
                    }
                }
                line = measuredLines.get(max);
                startX = this.getStartX(line.width());
                this.drawMarked(graphics, start.y, startX, end.x);
            }
        }
    }

    public Point getCursorPos(List<String> lines, int x, int y) {
        if (lines.isEmpty()) {
            return new Point();
        }
        List<TextRenderer.Line> measuredLines = this.measureStringLines(lines);
        int lineIndex = (int)((float)(y -= this.getStartY(measuredLines.size())) / this.getFontHeight());
        if (lineIndex < 0) {
            return new Point();
        }
        if (lineIndex >= measuredLines.size()) {
            return new Point(FontRenderHelper.length(measuredLines.get(measuredLines.size() - 1).text()), measuredLines.size() - 1);
        }
        TextRenderer.Line line = measuredLines.get(lineIndex);
        x -= this.getStartX(line.width());
        if (line.width() <= 0.0f) {
            return new Point(0, lineIndex);
        }
        if (line.width() < (float)x) {
            return new Point(FontRenderHelper.length(line.text()), lineIndex);
        }
        float fx = x;
        MutableFloat currentX = new MutableFloat();
        MutableInt xIndex = new MutableInt();
        line.text().m_13731_((positionInCurrentSequence, style, codePoint) -> {
            float charWidth = TextFieldRenderer.getFont().m_92724_(FormattedCharSequence.m_13693_((int)codePoint, (Style)style));
            currentX.add(charWidth);
            if (currentX.floatValue() >= fx) {
                if (Math.abs(currentX.floatValue() - fx) < Math.abs(currentX.floatValue() - charWidth - fx)) {
                    xIndex.increment();
                }
                return false;
            }
            xIndex.increment();
            return true;
        });
        return new Point(xIndex.intValue(), lineIndex);
    }

    public PointF getPosOf(List<TextRenderer.Line> measuredLines, Point cursorPos) {
        if (measuredLines.isEmpty()) {
            return new PointF(this.getStartX(0.0f), this.getStartYOfLines(1));
        }
        TextRenderer.Line line = measuredLines.get(cursorPos.y);
        float width = TextFieldRenderer.getFont().m_92865_().m_92336_(FontRenderHelper.substring(line.text(), 0, cursorPos.x + 1));
        return new PointF((float)this.getStartX(line.width()) + width * this.scale, (float)this.getStartYOfLines(measuredLines.size()) + (float)cursorPos.y * this.getFontHeight());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawMarked(GuiGraphics graphics, float y0, float x0, float x1) {
        RenderSystem.enableBlend();
        GuiDraw.drawRect(graphics, x0, y0 -= 1.0f, x1 - x0, this.getFontHeight(), this.markedColor);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawCursor(GuiGraphics graphics, float x0, float y0) {
        x0 = (x0 - 0.8f) / this.scale;
        y0 = (y0 - 1.0f) / this.scale;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        GuiDraw.drawRect(graphics, x0, y0, 0.6f, 9.0f, this.cursorColor);
        graphics.m_280168_().m_85849_();
    }

    @Generated
    public void setMarkedColor(int markedColor) {
        this.markedColor = markedColor;
    }

    @Generated
    public void setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
    }
}

