/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.widgets.slot.ModularSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class SlotGroup {
    public static final int PLAYER_INVENTORY_PRIO = 0;
    public static final int STORAGE_SLOT_PRIO = 100;
    private final String name;
    private final List<Slot> slots = new ArrayList<Slot>();
    private final int rowSize;
    private final int shiftClickPriority;
    private final boolean allowShiftTransfer;
    private boolean allowSorting = true;
    private final boolean singleton;

    public static SlotGroup singleton(String name, int shiftClickPriority) {
        return new SlotGroup(name, 1, shiftClickPriority, true, true);
    }

    public SlotGroup(String name, int rowSize) {
        this(name, rowSize, true);
    }

    public SlotGroup(String name, int rowSize, boolean allowShiftTransfer) {
        this(name, rowSize, 100, allowShiftTransfer);
    }

    public SlotGroup(String name, int rowSize, int shiftClickPriority, boolean allowShiftTransfer) {
        this(name, rowSize, shiftClickPriority, allowShiftTransfer, false);
    }

    private SlotGroup(String name, int rowSize, int shiftClickPriority, boolean allowShiftTransfer, boolean singleton) {
        this.name = name;
        this.rowSize = rowSize;
        this.shiftClickPriority = shiftClickPriority;
        this.allowShiftTransfer = allowShiftTransfer;
        this.singleton = singleton;
    }

    @ApiStatus.Internal
    void addSlot(Slot slot) {
        this.slots.add(slot);
        if (this.isSingleton() && this.slots.size() > 1) {
            throw new IllegalStateException("Singleton slot group has more than one slot!");
        }
    }

    @ApiStatus.Internal
    void removeSlot(ModularSlot slot) {
        this.slots.remove((Object)slot);
    }

    public @UnmodifiableView List<Slot> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    public Slot getFirstSlotForSorting() {
        return this.slots.isEmpty() ? null : this.slots.get(0);
    }

    public boolean isAllowSorting() {
        return this.slots.size() > 1 && this.allowSorting;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getRowSize() {
        return this.rowSize;
    }

    @Generated
    public int getShiftClickPriority() {
        return this.shiftClickPriority;
    }

    @Generated
    public boolean isAllowShiftTransfer() {
        return this.allowShiftTransfer;
    }

    @NotNull
    @Generated
    public SlotGroup setAllowSorting(boolean allowSorting) {
        this.allowSorting = allowSorting;
        return this;
    }

    @Generated
    public boolean isSingleton() {
        return this.singleton;
    }
}

