/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.recipeviewer.handlers.RecipeViewerHandler;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.MouseData;
import brachy.modularui.value.sync.ItemSlotSyncHandler;
import brachy.modularui.value.sync.PhantomItemSlotSyncHandler;
import brachy.modularui.widgets.slot.ItemSlot;
import brachy.modularui.widgets.slot.ModularSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhantomItemSlot
extends ItemSlot
implements GhostIngredientSlot<ItemStack> {
    private PhantomItemSlotSyncHandler syncHandler;

    @Override
    public void onInit() {
        super.onInit();
        this.getContext().getRecipeViewerSettings().addGhostIngredientSlot(this);
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue instanceof PhantomItemSlotSyncHandler;
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.syncHandler = syncOrValue.castOrThrow(PhantomItemSlotSyncHandler.class);
    }

    @Override
    protected void drawOverlay(ModularGuiContext context) {
        RecipeViewerHandler handler = RecipeViewerHandler.getCurrent();
        if (handler.isHoveringOver(this)) {
            this.drawHighlight(context, this.getArea(), this.isHovering());
        } else {
            super.drawOverlay(context);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        MouseData mouseData = MouseData.create(button);
        this.syncHandler.syncToServer(100, mouseData::writeToPacket);
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return true;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        MouseData mouseData = MouseData.create((int)delta);
        this.syncHandler.syncToServer(101, mouseData::writeToPacket);
        return true;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
    }

    @Override
    public void setGhostIngredient(@NotNull ItemStack ingredient) {
        this.syncHandler.updateFromClient(ingredient);
    }

    @Override
    @Nullable
    public ItemStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        ItemStack itemStack;
        return this.areAncestorsEnabled() && this.syncHandler.isPhantom() && ingredient instanceof ItemStack && this.syncHandler.isItemValid(itemStack = (ItemStack)ingredient) ? itemStack : null;
    }

    @Override
    @NotNull
    public PhantomItemSlotSyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    @Override
    public PhantomItemSlot slot(ModularSlot slot) {
        return this.syncHandler(new PhantomItemSlotSyncHandler(slot));
    }

    @Override
    public PhantomItemSlot syncHandler(ItemSlotSyncHandler syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
        return this;
    }

    @Override
    public boolean handleAsVanillaSlot() {
        return false;
    }
}

