/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.integration.recipeviewer.handlers.GhostIngredientSlot;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.SlotTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.MouseData;
import brachy.modularui.value.sync.FluidSlotSyncHandler;
import brachy.modularui.widgets.AbstractFluidDisplayWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlot
extends AbstractFluidDisplayWidget<FluidSlot>
implements Interactable,
GhostIngredientSlot<FluidStack>,
IngredientProvider<FluidStack> {
    public static final int DEFAULT_SIZE = 18;
    public static final String UNIT_BUCKET = "B";
    public static final String UNIT_LITER = "L";
    private static final DecimalFormat TOOLTIP_FORMAT = new DecimalFormat("#.##");
    private static final IFluidTank EMPTY = new FluidTank(0);
    private FluidSlotSyncHandler syncHandler;
    private boolean alwaysShowFull = true;
    private boolean displayAmount = true;

    public FluidSlot() {
        this.tooltip().autoUpdate(true);
        this.tooltipBuilder(this::addTooltip);
    }

    protected void addTooltip(RichTooltip tooltip) {
        IFluidTank fluidTank = this.getFluidTank();
        FluidStack fluid = this.syncHandler.getValue();
        if (fluid != null && !fluid.isEmpty()) {
            ((RichTooltip)tooltip.addLine(IKey.lang(fluid.getDisplayName()))).spaceLine(2);
        }
        if (this.syncHandler.phantom()) {
            if (fluid != null) {
                if (this.syncHandler.controlsAmount()) {
                    tooltip.addLine(IKey.lang("modularui.fluid.phantom.amount", this.formatFluidTooltipAmount(fluid.getAmount()), this.getUnit()));
                }
            } else {
                tooltip.addLine(IKey.lang("gtceu.fluid.empty"));
                tooltip.addLine(IKey.lang("gtceu.fluid_pipe.capacity", this.formatFluidTooltipAmount(fluidTank.getCapacity()), this.getUnit()));
            }
            if (this.syncHandler.controlsAmount()) {
                tooltip.addLine(IKey.lang("modularui.fluid.phantom.control"));
            }
        } else {
            if (fluid != null) {
                tooltip.addLine(IKey.lang("gtceu.fluid.amount", this.formatFluidTooltipAmount(fluid.getAmount()), this.formatFluidTooltipAmount(fluidTank.getCapacity()), this.getUnit()));
                this.addAdditionalFluidInfo(tooltip, fluid);
            } else {
                tooltip.addLine(IKey.lang("gtceu.fluid.empty"));
            }
            if (this.syncHandler.canFillSlot() || this.syncHandler.canDrainSlot()) {
                tooltip.addLine(IKey.EMPTY);
                if (Interactable.hasShiftDown()) {
                    if (this.syncHandler.canFillSlot() && this.syncHandler.canDrainSlot()) {
                        tooltip.addLine(IKey.lang("gtceu.fluid.click_combined"));
                    } else if (this.syncHandler.canDrainSlot()) {
                        tooltip.addLine(IKey.lang("gtceu.fluid.click_to_fill"));
                    } else if (this.syncHandler.canFillSlot()) {
                        tooltip.addLine(IKey.lang("gtceu.fluid.click_to_empty"));
                    }
                } else {
                    tooltip.addLine(IKey.lang("gtceu.tooltip.hold_shift"));
                }
            }
        }
        if (fluid != null && !fluid.isEmpty()) {
            tooltip.add((FormattedText)this.getFluidModName(fluid));
        }
    }

    private Component getFluidModName(FluidStack fluidStack) {
        String modID = FluidSlot.getFluidModID(fluidStack.getFluid());
        Optional container = ModList.get().getModContainerById(modID);
        if (container.isPresent()) {
            return Component.m_237113_((String)((ModContainer)container.get()).getModInfo().getDisplayName()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
        }
        return Component.m_237113_((String)modID).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    public static String getFluidModID(Fluid fluid) {
        ResourceLocation modName = BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
        return modName.m_135827_();
    }

    public void addAdditionalFluidInfo(RichTooltip tooltip, FluidStack fluidStack) {
    }

    public String formatFluidTooltipAmount(double amount) {
        return TOOLTIP_FORMAT.format(amount);
    }

    @Override
    public void onInit() {
        this.getContext().getRecipeViewerSettings().addGhostIngredientSlot(this);
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(FluidSlotSyncHandler.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.syncHandler = syncOrValue.castNullable(FluidSlotSyncHandler.class);
    }

    @Override
    protected boolean displayAmountText() {
        return this.syncHandler == null || this.syncHandler.controlsAmount();
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        if (this.isHovering()) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(context.getGraphics(), 1.0f, 1.0f, this.getArea().w() - 2, this.getArea().h() - 2, this.getSlotHoverColor());
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    public int getSlotHoverColor() {
        WidgetThemeEntry<SlotTheme> theme = this.getWidgetTheme(this.getPanel().getTheme(), SlotTheme.class);
        return theme.theme().getSlotHoverColor();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        if (!this.syncHandler.canFillSlot() && !this.syncHandler.canDrainSlot()) {
            return Interactable.Result.ACCEPT;
        }
        ItemStack cursorStack = Minecraft.m_91087_().f_91074_.f_36096_.m_142621_();
        if (this.syncHandler.phantom() || !cursorStack.m_41619_() && cursorStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).isPresent()) {
            MouseData mouseData = MouseData.create(button);
            this.syncHandler.syncToServer(1, mouseData::writeToPacket);
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.syncHandler.phantom()) {
            if (delta > 0.0 && !this.syncHandler.canFillSlot() || delta < 0.0 && !this.syncHandler.canDrainSlot()) {
                return false;
            }
            MouseData mouseData = MouseData.create(delta > 0.0 ? 1 : -1);
            this.syncHandler.syncToServer(2, mouseData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    protected int getCapacity() {
        return this.alwaysShowFull ? 0 : this.getFluidTank().getCapacity();
    }

    @Override
    @Nullable
    public FluidStack getFluidStack() {
        return this.syncHandler == null ? null : this.syncHandler.getValue();
    }

    public IFluidTank getFluidTank() {
        return this.syncHandler == null ? EMPTY : this.syncHandler.fluidTank();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public FluidSlot contentOffset(int x, int y) {
        return (FluidSlot)((FluidSlot)this.contentPaddingLeft(x)).contentPaddingTop(y);
    }

    public FluidSlot displayAmount(boolean displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public FluidSlot alwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public FluidSlot overlayTexture(@Nullable IDrawable overlayTexture) {
        return (FluidSlot)this.overlay(overlayTexture);
    }

    public FluidSlot syncHandler(IFluidTank fluidTank) {
        return this.syncHandler(new FluidSlotSyncHandler(fluidTank));
    }

    public FluidSlot syncHandler(FluidSlotSyncHandler syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
        return this;
    }

    @Override
    public void setGhostIngredient(@NotNull FluidStack ingredient) {
        if (this.syncHandler.phantom()) {
            this.syncHandler.setValue(ingredient);
        }
    }

    @Override
    @Nullable
    public FluidStack castGhostIngredientIfValid(@NotNull Object ingredient) {
        FluidStack fluidStack;
        return this.areAncestorsEnabled() && this.syncHandler.phantom() && ingredient instanceof FluidStack ? (fluidStack = (FluidStack)ingredient) : null;
    }

    static {
        TOOLTIP_FORMAT.setGroupingUsed(true);
        TOOLTIP_FORMAT.setGroupingSize(3);
    }
}

