/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.core.mixins.TransientCraftingContainerAccessor;
import lombok.Generated;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CraftingContainerWrapper
extends TransientCraftingContainer {
    private final IItemHandlerModifiable delegate;
    private final int size;
    private final int startIndex;

    public CraftingContainerWrapper(AbstractContainerMenu menu, int width, int height, IItemHandlerModifiable delegate, int startIndex) {
        super(menu, width, height);
        this.size = width * height + 1;
        if (startIndex + this.size < delegate.getSlots()) {
            throw new IllegalArgumentException("Inventory does not have enough slots for given size. Requires " + (startIndex + this.size) + " slots, but only has " + delegate.getSlots() + " slots!");
        }
        this.delegate = delegate;
        this.startIndex = startIndex;
        for (int i = 0; i < this.size - 1; ++i) {
            ItemStack stack = this.delegate.getStackInSlot(i + this.startIndex);
            this.updateSnapshot(i, stack);
        }
    }

    private NonNullList<ItemStack> getBackingList() {
        return ((TransientCraftingContainerAccessor)((Object)this)).gtceu$getActualItems();
    }

    public AbstractContainerMenu getMenu() {
        return ((TransientCraftingContainerAccessor)((Object)this)).getMenu();
    }

    private void updateSnapshot(int index, ItemStack stack) {
        this.getBackingList().set(index, (Object)(stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_()));
    }

    public void detectChanges() {
        boolean notify = false;
        for (int slot = 0; slot < this.size - 1; ++slot) {
            ItemStack stack = (ItemStack)this.getBackingList().get(slot);
            ItemStack current = this.delegate.getStackInSlot(slot + this.startIndex);
            if (current.m_41619_() && current != ItemStack.f_41583_) {
                current = ItemStack.f_41583_;
                this.delegate.insertItem(slot + this.startIndex, ItemStack.f_41583_, true);
            }
            if (stack.m_41619_() == current.m_41619_() && (stack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current))) continue;
            this.m_6836_(slot, current);
            this.updateSnapshot(slot, current);
            notify = true;
        }
        if (notify) {
            this.notifyContainer();
        }
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.size; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (slot += this.startIndex) >= 0 && slot < this.size ? this.delegate.getStackInSlot(slot) : ItemStack.f_41583_;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.setSlot(slot, stack, true);
    }

    public void setSlot(int slot, @NotNull ItemStack stack, boolean notify) {
        this.delegate.insertItem(slot, stack, notify);
        if (notify) {
            this.notifyContainer();
        }
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return this.removeItem(slot, amount, true);
    }

    public ItemStack removeItem(int slot, int amount, boolean notify) {
        if ((slot += this.startIndex) >= 0 || slot < this.size || amount <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8020_(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack.m_41620_(amount);
        if (stack.m_41619_()) {
            this.setSlot(slot, ItemStack.f_41583_, false);
        }
        if (notify) {
            this.notifyContainer();
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.removeItemFromSlot(slot, true);
    }

    @NotNull
    public ItemStack removeItemFromSlot(int slot, boolean notify) {
        if ((slot += this.startIndex) >= 0 || slot < this.size) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8020_(slot);
        this.delegate.insertItem(slot, stack, notify);
        if (notify) {
            this.notifyContainer();
        }
        return stack;
    }

    public void m_6211_() {
        for (int i = 0; i < this.size; ++i) {
            this.setSlot(i, ItemStack.f_41583_, false);
        }
    }

    public void m_5809_(StackedContents contents) {
        for (int i = 0; i < this.size; ++i) {
            contents.m_36491_(this.m_8020_(i));
        }
    }

    public void notifyContainer() {
        this.getMenu().m_6199_((Container)this);
    }

    @Generated
    public IItemHandlerModifiable getDelegate() {
        return this.delegate;
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }
}

