/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.menu;

import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.StandardResizer;
import brachy.modularui.widgets.menu.IMenuPart;
import brachy.modularui.widgets.menu.Menu;
import brachy.modularui.widgets.menu.MenuPanel;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMenuButton<W extends AbstractMenuButton<W>>
extends Widget<W>
implements IMenuPart,
Interactable {
    protected Direction direction = Direction.DOWN;
    protected boolean openOnHover = true;
    private Menu<?> menu;
    private boolean open;
    private boolean softOpen;
    private IPanelHandler panelHandler;
    private final String panelName;

    public AbstractMenuButton(String panelName) {
        this.panelName = Objects.requireNonNull(panelName);
        this.name(panelName);
    }

    protected boolean isSoftOpen() {
        return this.softOpen;
    }

    protected void toggleMenu(boolean soft) {
        if (this.open) {
            if (this.softOpen) {
                if (soft) {
                    this.closeMenu(true);
                } else {
                    this.softOpen = false;
                }
            } else if (!soft) {
                if (this.openOnHover) {
                    this.softOpen = true;
                } else {
                    this.closeMenu(false);
                }
            }
        } else {
            this.openMenu(soft);
        }
    }

    protected void openMenu(boolean soft) {
        if (this.open) {
            if (this.softOpen && !soft) {
                this.softOpen = false;
            }
            return;
        }
        ModularPanel modularPanel = this.getPanel();
        if (modularPanel instanceof MenuPanel) {
            MenuPanel menuPanel = (MenuPanel)modularPanel;
            menuPanel.openSubMenu(this.getMenu());
        } else {
            this.getPanelHandler().openPanel();
        }
        this.open = true;
        this.softOpen = soft;
    }

    protected void closeMenu(boolean soft) {
        if (!this.open || !this.softOpen && soft) {
            return;
        }
        ModularPanel modularPanel = this.getPanel();
        if (modularPanel instanceof MenuPanel) {
            MenuPanel menuPanel = (MenuPanel)modularPanel;
            menuPanel.remove(this.getMenu());
        } else {
            this.getPanelHandler().closePanel();
        }
        this.open = false;
        this.softOpen = false;
    }

    protected Menu<?> getMenu() {
        if (this.menu == null) {
            this.menu = this.createMenu();
            if (this.menu == null) {
                this.menu = (Menu)((Menu)((Menu)new Menu().child((IWidget)IKey.str("No Menu supplied").style(ChatFormatting.RED).asWidget().center())).widthRel(1.0f)).height(16);
                if (this.direction == null) {
                    Direction.DOWN.positioner.accept(this.menu.resizer());
                }
            }
        }
        if (!this.menu.resizer().hasParentOverride()) {
            this.menu.resizer().relative(this);
        }
        if (this.direction != null) {
            this.direction.positioner.accept(this.menu.resizer());
        }
        this.menu.setMenuSource(this);
        return this.menu;
    }

    protected void setMenu(Menu<?> menu) {
        this.menu = menu;
    }

    protected abstract Menu<?> createMenu();

    private IPanelHandler getPanelHandler() {
        if (this.panelHandler == null) {
            this.panelHandler = IPanelHandler.simple(this.getPanel(), (parentPanel, player) -> new MenuPanel(this.panelName, this.getMenu()), true);
        }
        return this.panelHandler;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double x, double y, int mouseButton) {
        if (!this.open) {
            this.forEachSiblingMenuButton(w -> {
                w.closeMenu(false);
                return true;
            });
        }
        this.toggleMenu(false);
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseEnterArea() {
        super.onMouseEnterArea();
        if (this.openOnHover && this.forEachSiblingMenuButton(mb -> !mb.open || mb.softOpen)) {
            this.openMenu(true);
        }
    }

    protected boolean forEachSiblingMenuButton(Predicate<AbstractMenuButton<?>> test) {
        Menu menuParent = WidgetTree.findParent(this, Menu.class);
        if (menuParent != null) {
            return WidgetTree.foreachChild(menuParent, w -> {
                AbstractMenuButton mb;
                return !(w instanceof AbstractMenuButton) || (mb = (AbstractMenuButton)w) == this || test.test(mb);
            }, false);
        }
        return true;
    }

    @Override
    public void onMouseLeaveArea() {
        super.onMouseLeaveArea();
        this.checkClose();
    }

    protected void checkClose() {
        if (this.openOnHover && !this.isSelfOrChildHovered()) {
            this.closeMenu(true);
            Menu menuParent = WidgetTree.findParent(this, Menu.class);
            if (menuParent != null) {
                menuParent.checkClose();
            }
        }
    }

    @Override
    public boolean isSelfOrChildHovered() {
        if (this.isBelowMouse()) {
            return true;
        }
        if (!this.isOpen() || this.menu == null) {
            return false;
        }
        return this.menu.isSelfOrChildHovered();
    }

    @Override
    protected WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getButtonTheme();
    }

    @Generated
    public boolean isOpen() {
        return this.open;
    }

    public static enum Direction {
        UP(resizer -> resizer.bottomRel(1.0f)),
        DOWN(resizer -> resizer.topRel(1.0f)),
        LEFT_UP(resizer -> ((StandardResizer)resizer.rightRel(1.0f)).bottom(0)),
        LEFT_DOWN(resizer -> ((StandardResizer)resizer.rightRel(1.0f)).top(0)),
        RIGHT_UP(resizer -> ((StandardResizer)resizer.leftRel(1.0f)).bottom(0)),
        RIGHT_DOWN(resizer -> ((StandardResizer)resizer.leftRel(1.0f)).top(0)),
        UNDEFINED(resizer -> {});

        private final Consumer<StandardResizer> positioner;

        private Direction(Consumer<StandardResizer> positioner) {
            this.positioner = positioner;
        }
    }
}

