/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.Box;
import java.util.Objects;
import java.util.function.IntSupplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class TextWidget<W extends TextWidget<W>>
extends Widget<W> {
    private final IKey key;
    private Alignment alignment = Alignment.CenterLeft;
    private IntSupplier color = null;
    private Boolean shadow = null;
    private float scale = 1.0f;
    private int maxWidth = -1;
    private Component lastText = null;
    private Component textForDefaultSize = null;

    public TextWidget(IKey key) {
        this.key = key;
    }

    public TextWidget(String key) {
        this(IKey.str(key));
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        TextRenderer renderer = TextRenderer.SHARED;
        Component text = this.checkString();
        WidgetTheme theme = this.getActiveWidgetTheme(widgetTheme, this.isHovering());
        renderer.setColor(this.color != null ? this.color.getAsInt() : theme.getTextColor());
        renderer.setAlignment(this.alignment, (float)this.getArea().paddedWidth() + this.scale, this.getArea().paddedHeight());
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : theme.isTextShadow());
        renderer.setPos(this.getArea().getPadding().left(), this.getArea().getPadding().top());
        renderer.setScale(this.scale);
        renderer.setSimulate(false);
        renderer.draw(context.getGraphics(), text);
    }

    protected Component checkString() {
        MutableComponent text = this.key.getFormatted();
        if (!Objects.equals(this.lastText, text)) {
            this.onTextChanged((Component)text);
            this.lastText = text;
        }
        return text;
    }

    protected void onTextChanged(Component newText) {
        WidgetTree.resizeInternal(this.resizer(), false);
    }

    private TextRenderer simulate(float maxWidth) {
        Box padding = this.getArea().getPadding();
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setAlignment(Alignment.TopLeft, maxWidth);
        renderer.setPos(padding.left(), padding.top());
        renderer.setScale(this.scale);
        renderer.setSimulate(true);
        renderer.draw(null, this.getComponentForDefaultSize());
        renderer.setSimulate(false);
        return renderer;
    }

    @Override
    public int getDefaultHeight() {
        float maxWidth = this.resizer().isWidthCalculated() ? (float)this.getArea().width + this.scale : (this.maxWidth > 0 ? (float)Math.max(this.maxWidth, 5) : (this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width + this.scale : (float)this.getScreen().getScreenArea().width));
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetHeight(renderer.getLastHeight());
    }

    @Override
    public int getDefaultWidth() {
        float maxWidth = this.maxWidth > 0 ? (float)Math.max(this.maxWidth, 5) : (this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width : (float)this.getScreen().getScreenArea().width);
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetWidth(renderer.getLastWidth());
    }

    protected int getWidgetWidth(float actualTextWidth) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextWidth + (float)padding.horizontal()));
    }

    protected int getWidgetHeight(float actualTextHeight) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextHeight + (float)padding.vertical()));
    }

    @Override
    public boolean canHoverThrough() {
        return true;
    }

    protected Component getComponentForDefaultSize() {
        if (this.textForDefaultSize == null) {
            this.lastText = this.textForDefaultSize = this.key.get();
        }
        return this.textForDefaultSize;
    }

    @Override
    public void postResize() {
        this.textForDefaultSize = null;
    }

    public W alignment(Alignment alignment) {
        this.alignment = alignment;
        return (W)((TextWidget)this.getThis());
    }

    public W color(int color) {
        return this.color(() -> color);
    }

    public W color(@Nullable IntSupplier color) {
        this.color = color;
        return (W)((TextWidget)this.getThis());
    }

    public W scale(float scale) {
        this.scale = scale;
        return (W)((TextWidget)this.getThis());
    }

    public W shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return (W)((TextWidget)this.getThis());
    }

    public W style(ChatFormatting formatting) {
        this.key.style(formatting);
        return (W)((TextWidget)this.getThis());
    }

    public W maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return (W)((TextWidget)this.getThis());
    }

    public Boolean isShadow() {
        return this.getShadow();
    }

    @Generated
    public IKey getKey() {
        return this.key;
    }

    @Generated
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Generated
    public IntSupplier getColor() {
        return this.color;
    }

    @Generated
    public Boolean getShadow() {
        return this.shadow;
    }

    @Generated
    public float getScale() {
        return this.scale;
    }
}

