/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.widget.ISynced;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.widget.ParentWidget;
import brachy.modularui.widget.sizer.StandardResizer;
import brachy.modularui.widgets.SortButtons;
import brachy.modularui.widgets.slot.ItemSlot;
import brachy.modularui.widgets.slot.SlotGroup;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class SlotGroupWidget
extends ParentWidget<SlotGroupWidget> {
    private String slotGroupName;
    private SlotGroup slotGroup;
    private boolean sortButtonsAdded = false;
    private Consumer<SortButtons> sortButtonsEditor;

    public static SlotGroupWidget playerInventory(boolean positioned) {
        return positioned ? SlotGroupWidget.playerInventory(7, true) : SlotGroupWidget.playerInventory((index, slot) -> slot);
    }

    public static SlotGroupWidget playerInventory(boolean positioned, SlotConsumer slotConsumer) {
        return positioned ? SlotGroupWidget.playerInventory(7, true, slotConsumer) : SlotGroupWidget.playerInventory(slotConsumer);
    }

    public static SlotGroupWidget playerInventory(int bottom, boolean horizontalCentered) {
        return SlotGroupWidget.playerInventory(bottom, horizontalCentered, (index, slot) -> slot);
    }

    public static SlotGroupWidget playerInventory(int bottom, boolean horizontalCentered, SlotConsumer slotConsumer) {
        SlotGroupWidget widget = SlotGroupWidget.playerInventory(slotConsumer);
        if (bottom != 0) {
            widget.bottom(bottom);
        }
        if (horizontalCentered) {
            widget.leftRel(0.5f);
        }
        return widget;
    }

    public static SlotGroupWidget playerInventory(SlotConsumer slotConsumer) {
        int i;
        SlotGroupWidget slotGroupWidget = new SlotGroupWidget();
        slotGroupWidget.coverChildren();
        slotGroupWidget.name("player_inventory");
        String key = "player";
        for (i = 0; i < 9; ++i) {
            slotGroupWidget.child(((ItemSlot)((ItemSlot)slotConsumer.apply(i, new ItemSlot()).syncHandler(key, i)).pos(i * 18, 58)).name("slot_" + i));
        }
        for (i = 0; i < 27; ++i) {
            slotGroupWidget.child(((ItemSlot)((ItemSlot)slotConsumer.apply(i + 9, new ItemSlot()).syncHandler(key, i + 9)).pos(i % 9 * 18, i / 9 * 18)).name("slot_" + (i + 9)));
        }
        return slotGroupWidget;
    }

    @Override
    public void onInit() {
        super.onInit();
        if (!this.sortButtonsAdded) {
            SortButtons sb = new SortButtons();
            if (this.sortButtonsEditor == null) {
                this.placeSortButtonsTopRightHorizontal();
            }
            if (this.getName() != null) {
                sb.name(this.getName() + "_sorter_buttons");
            }
            this.child(sb);
        }
    }

    @Override
    public void afterInit() {
        block3: {
            block2: {
                super.afterInit();
                if (this.slotGroup == null) break block2;
                for (IWidget widget : this.getChildren()) {
                    if (!(widget instanceof ItemSlot)) continue;
                    ItemSlot itemSlot = (ItemSlot)widget;
                    itemSlot.getSlot().slotGroup(this.slotGroup);
                }
                break block3;
            }
            if (this.slotGroupName == null) break block3;
            for (IWidget widget : this.getChildren()) {
                if (!(widget instanceof ItemSlot)) continue;
                ItemSlot itemSlot = (ItemSlot)widget;
                itemSlot.getSlot().slotGroup(this.slotGroupName);
            }
        }
    }

    @Override
    protected void onChildAdd(IWidget child) {
        super.onChildAdd(child);
        if (child instanceof SortButtons) {
            SortButtons sortButtons = (SortButtons)child;
            this.sortButtonsAdded = true;
            if (sortButtons.getSlotGroup() == null && sortButtons.getSlotGroupName() == null) {
                if (this.slotGroup != null) {
                    sortButtons.slotGroup(this.slotGroup);
                } else if (this.slotGroupName != null) {
                    sortButtons.slotGroup(this.slotGroupName);
                }
            }
            if (this.sortButtonsEditor != null) {
                this.sortButtonsEditor.accept(sortButtons);
            }
        }
    }

    public SlotGroupWidget disableSortButtons() {
        this.sortButtonsAdded = true;
        return this;
    }

    public void setSlotsSynced(String name) {
        int i = 0;
        for (IWidget widget : this.getChildren()) {
            if (widget instanceof ISynced) {
                ISynced synced = (ISynced)((Object)widget);
                synced.syncHandler(name, i);
            }
            ++i;
        }
    }

    public SlotGroupWidget editSortButtons(Consumer<SortButtons> sortButtonsEditor) {
        this.sortButtonsEditor = sortButtonsEditor;
        return this;
    }

    public SlotGroupWidget placeSortButtonsTopRightVertical() {
        return this.placeSortButtonsTopRightVertical(this.sortButtonsEditor);
    }

    public SlotGroupWidget placeSortButtonsTopRightHorizontal() {
        return this.placeSortButtonsTopRightHorizontal(this.sortButtonsEditor);
    }

    public SlotGroupWidget placeSortButtonsTopRightVertical(Consumer<SortButtons> additionalEdits) {
        return this.editSortButtons(sb -> {
            ((SortButtons)sb.vertical().leftRelOffset(1.0f, 1)).top(0);
            if (additionalEdits != null) {
                additionalEdits.accept((SortButtons)sb);
            }
        });
    }

    public SlotGroupWidget placeSortButtonsTopRightHorizontal(Consumer<SortButtons> additionalEdits) {
        return this.editSortButtons(sb -> {
            ((SortButtons)sb.horizontal().bottomRelOffset(1.0f, 1)).right(0);
            if (additionalEdits != null) {
                additionalEdits.accept((SortButtons)sb);
            }
        });
    }

    public SlotGroupWidget slotGroup(String slotGroupName) {
        this.slotGroupName = slotGroupName;
        return this;
    }

    public SlotGroupWidget slotGroup(SlotGroup slotGroup) {
        this.slotGroup = slotGroup;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface SlotConsumer {
        public ItemSlot apply(int var1, ItemSlot var2);
    }

    public static class Builder {
        private String syncKey;
        private final List<String> matrix = new ArrayList<String>();
        private final Char2ObjectMap<Object> keys = new Char2ObjectOpenHashMap();
        private String slotGroupName;
        private SlotGroup slotGroup;

        private Builder() {
            this.keys.put(' ', null);
        }

        public Builder synced(String name) {
            this.syncKey = name;
            return this;
        }

        public Builder matrix(String ... matrix) {
            this.matrix.clear();
            Collections.addAll(this.matrix, matrix);
            return this;
        }

        public Builder row(String row) {
            this.matrix.add(row);
            return this;
        }

        public Builder key(char c, IWidget widget) {
            this.keys.put(c, (Object)widget);
            return this;
        }

        public Builder key(char c, IntFunction<IWidget> widget) {
            this.keys.put(c, widget);
            return this;
        }

        public Builder slotGroup(String slotGroupName) {
            this.slotGroupName = slotGroupName;
            return this;
        }

        public Builder slotGroup(SlotGroup slotGroup) {
            this.slotGroup = slotGroup;
            return this;
        }

        public SlotGroupWidget build() {
            SlotGroupWidget slotGroupWidget = new SlotGroupWidget().slotGroup(this.slotGroupName).slotGroup(this.slotGroup);
            Char2IntOpenHashMap charCount = new Char2IntOpenHashMap();
            int x = 0;
            int y = 0;
            int maxWidth = 0;
            int syncId = 0;
            for (String row : this.matrix) {
                for (int i = 0; i < row.length(); ++i) {
                    IWidget widget;
                    char c = row.charAt(i);
                    int count = charCount.get(c);
                    charCount.put(c, count + 1);
                    Object o = this.keys.get(c);
                    if (o instanceof IWidget) {
                        IWidget iWidget;
                        widget = iWidget = (IWidget)o;
                        if (count > 0) {
                            throw new IllegalArgumentException("A widget can only exist once in the widget tree, but the char '" + c + "' exists more than once in this slot group widget and it has a static widget supplied.");
                        }
                    } else if (o instanceof IntFunction) {
                        IntFunction function = (IntFunction)o;
                        widget = (IWidget)function.apply(count);
                    } else {
                        x += 18;
                        continue;
                    }
                    ((StandardResizer)widget.resizer().left(x)).top(y);
                    slotGroupWidget.child(widget);
                    if (this.syncKey != null && widget instanceof ISynced) {
                        ISynced synced = (ISynced)((Object)widget);
                        synced.syncHandler(this.syncKey, syncId++);
                    }
                    maxWidth = Math.max(maxWidth, x += 18);
                }
                y += 18;
                x = 0;
            }
            slotGroupWidget.resizer().size(maxWidth, this.matrix.size() * 18);
            return slotGroupWidget;
        }
    }
}

