/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.animation.Animator;
import brachy.modularui.animation.IAnimator;
import brachy.modularui.animation.SequentialAnimator;
import brachy.modularui.animation.Wait;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Interpolation;
import brachy.modularui.widgets.TextWidget;
import net.minecraft.network.chat.Component;

public class ScrollingTextWidget
extends TextWidget<ScrollingTextWidget> {
    private TextRenderer.Line line;
    private float progress = 0.0f;
    private IAnimator animator;
    private Animator forward;
    private Animator backward;
    private int speed = 15;

    public ScrollingTextWidget(IKey key) {
        super(key);
        this.tooltipBuilder(tooltip -> {
            tooltip.showUpTimer(10);
            if (this.line.width() > (float)this.getArea().width) {
                tooltip.addLine(key);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.animator != null) {
            this.animator.stop(true);
        }
    }

    @Override
    public void onMouseStartHover() {
        super.onMouseStartHover();
        this.animator.resume(false);
    }

    @Override
    public void onMouseEndHover() {
        super.onMouseEndHover();
        this.animator.stop(true);
        this.animator.reset();
        this.progress = 0.0f;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        if (this.animator == null) {
            this.animator(new Animator().curve(Interpolation.SINE_INOUT));
        }
        if (this.line == null) {
            this.updateLine((Component)this.getKey().getFormatted());
        }
        this.checkString();
        WidgetTheme theme = this.getActiveWidgetTheme(widgetTheme, this.isHovering());
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setColor(this.getColor() != null ? this.getColor().getAsInt() : theme.getTextColor());
        renderer.setAlignment(this.getAlignment(), this.getArea().w(), this.getArea().h());
        renderer.setShadow(this.isShadow() != null ? this.isShadow().booleanValue() : theme.isTextShadow());
        renderer.setPos(this.getArea().getPadding().left(), this.getArea().getPadding().top());
        renderer.setScale(this.getScale());
        renderer.setSimulate(false);
        if (this.isHovering()) {
            renderer.drawScrolling(context.getGraphics(), this.line, this.progress, this.getArea(), context);
        } else {
            renderer.drawCut(context.getGraphics(), this.line);
        }
    }

    @Override
    protected void onTextChanged(Component newText) {
        super.onTextChanged(newText);
        this.updateLine(newText);
        this.markTooltipDirty();
    }

    protected void updateLine(Component newText) {
        TextRenderer.SHARED.setScale(this.getScale());
        this.line = TextRenderer.SHARED.line(newText.m_7532_());
        this.animator.stop(true);
        this.animator.reset();
        this.forward.duration(this.line.upperWidth() * this.speed);
        this.backward.duration(this.forward.getDuration() * 3 / 4);
    }

    public ScrollingTextWidget scrollSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public ScrollingTextWidget animator(Animator animator) {
        this.forward = animator.onUpdate(val -> {
            this.progress = (float)val;
        });
        this.backward = animator.copy(true);
        this.animator = new SequentialAnimator(this.forward, new Wait(500), this.backward, new Wait(1000)).repeatsOnFinish(20);
        return this;
    }
}

