/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.drawable.IHoverable;
import brachy.modularui.api.drawable.IRichTextBuilder;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.text.RichText;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.widget.Widget;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RichTextWidget
extends Widget<RichTextWidget>
implements IRichTextBuilder<RichTextWidget>,
Interactable {
    private final RichText text = new RichText();
    private Consumer<RichText> builder;
    private boolean dirty = false;
    private boolean autoUpdate = false;

    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.draw(context, widgetTheme);
        if (this.autoUpdate || this.dirty) {
            if (this.builder != null) {
                this.text.clearText();
                this.builder.accept(this.text);
            }
            this.dirty = false;
        }
        this.text.drawAtZeroPadded(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        super.drawForeground(context);
        Object object = this.getHoveredElement(context);
        if (object instanceof IHoverable) {
            IHoverable hoverable = (IHoverable)object;
            hoverable.onHover();
            RichTooltip tooltip = hoverable.getTooltip();
            if (tooltip != null) {
                tooltip.draw(context);
            }
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMousePressed(mouseX, mouseY, button);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(double mouseX, double mouseY, int button) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseTapped(mouseX, mouseY, button);
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyReleased(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(int keyCode, int scanCode, int modifiers) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onKeyTapped(keyCode, scanCode, modifiers);
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            return interactable.onMouseScrolled(mouseX, mouseY, delta);
        }
        return false;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Object object = this.getHoveredElement();
        if (object instanceof Interactable) {
            Interactable interactable = (Interactable)object;
            interactable.onMouseDrag(mouseX, mouseY, button, dragX, dragY);
        }
    }

    @Nullable
    public Object getHoveredElement() {
        return this.getHoveredElement(this.getContext());
    }

    @Nullable
    public Object getHoveredElement(ModularGuiContext context) {
        if (!this.isHovering()) {
            return null;
        }
        return this.text.getHoveringElement(context);
    }

    @Override
    public IRichTextBuilder<?> getRichText() {
        return this.text;
    }

    public RichTextWidget autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public RichTextWidget textBuilder(Consumer<RichText> builder) {
        this.builder = builder;
        this.markDirty();
        return this;
    }
}

