/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.value.sync.DynamicLinkedSyncHandler;
import brachy.modularui.value.sync.DynamicSyncHandler;
import brachy.modularui.value.sync.IDynamicSyncNotifiable;
import brachy.modularui.widget.Widget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DynamicSyncedWidget<W extends DynamicSyncedWidget<W>>
extends Widget<W> {
    private IDynamicSyncNotifiable syncHandler;
    private IWidget child;

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IDynamicSyncNotifiable.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.syncHandler = syncOrValue.castNullable(IDynamicSyncNotifiable.class);
        if (this.syncHandler != null) {
            this.syncHandler.attachDynamicWidgetListener(this::updateChild);
        }
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        if (this.child == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.child);
    }

    private void updateChild(IWidget widget) {
        if (this.child != null) {
            this.child.dispose();
        } else if (widget == null) {
            return;
        }
        this.child = widget;
        if (this.isValid()) {
            if (this.child != null) {
                this.child.initialise(this, true);
            }
            this.scheduleResize();
        }
    }

    public W syncHandler(DynamicSyncHandler syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
        return (W)((DynamicSyncedWidget)this.getThis());
    }

    public W syncHandler(DynamicLinkedSyncHandler<?> syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
        return (W)((DynamicSyncedWidget)this.getThis());
    }

    public W initialChild(IWidget child) {
        if (this.isValid()) {
            throw new IllegalStateException("Can only set initial child before the widget is initialised.");
        }
        this.child = child;
        return (W)((DynamicSyncedWidget)this.getThis());
    }
}

