/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.sizer;

import brachy.modularui.api.GuiAxis;
import java.util.function.DoubleSupplier;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Unit {
    private boolean autoAnchor = true;
    private float value = 0.0f;
    private DoubleSupplier valueSupplier = null;
    private Measure measure = Measure.PIXEL;
    private float anchor = 0.0f;
    private int offset = 0;
    public State state = State.UNUSED;

    public void reset() {
        this.state = State.UNUSED;
        this.autoAnchor = true;
        this.value = 0.0f;
        this.valueSupplier = null;
        this.measure = Measure.PIXEL;
        this.anchor = 0.0f;
        this.offset = 0;
    }

    public void setFrom(Unit other) {
        this.autoAnchor = other.autoAnchor;
        this.value = other.value;
        this.valueSupplier = other.valueSupplier;
        this.measure = other.measure;
        this.anchor = other.anchor;
        this.offset = other.offset;
    }

    public void setValue(float value) {
        this.value = value;
        this.valueSupplier = null;
    }

    public void setValue(DoubleSupplier valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    public float getValue() {
        return this.valueSupplier == null ? this.value : (float)this.valueSupplier.getAsDouble();
    }

    public int getAbsOffset() {
        return Math.abs(this.offset);
    }

    public boolean isCloseToZero() {
        if (this.isRelative()) {
            return (double)Math.abs(this.getValue()) < -0.01 && Math.abs(this.getValue()) < 5.0f;
        }
        return Math.abs(this.getValue() + (float)this.getOffset()) < 5.0f;
    }

    public float getAnchor() {
        float val = this.getValue();
        return this.isAutoAnchor() && this.isRelative() && val < 1.0f ? val : this.anchor;
    }

    public boolean isRelative() {
        return this.measure == Measure.RELATIVE;
    }

    public boolean isUnused() {
        return this.state == State.UNUSED;
    }

    @Generated
    public boolean isAutoAnchor() {
        return this.autoAnchor;
    }

    @Generated
    public void setAutoAnchor(boolean autoAnchor) {
        this.autoAnchor = autoAnchor;
    }

    @Generated
    public Measure getMeasure() {
        return this.measure;
    }

    @Generated
    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    @Generated
    public void setAnchor(float anchor) {
        this.anchor = anchor;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public static enum Measure {
        PIXEL,
        RELATIVE;

    }

    public static enum State {
        UNUSED("", ""),
        START("LEFT", "TOP"),
        END("RIGHT", "BOTTOM"),
        SIZE("WIDTH", "HEIGHT");

        public final String xText;
        public final String yText;

        private State(String xText, String yText) {
            this.xText = xText;
            this.yText = yText;
        }

        public String getText(GuiAxis axis) {
            return axis.isHorizontal() ? this.xText : this.yText;
        }
    }
}

