/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.sizer;

import brachy.modularui.GuiError;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.layout.ILayoutWidget;
import brachy.modularui.api.widget.IDelegatingWidget;
import brachy.modularui.api.widget.IPositioned;
import brachy.modularui.api.widget.IVanillaSlot;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.core.mixins.client.SlotAccessor;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.Box;
import brachy.modularui.widget.sizer.DimensionSizer;
import brachy.modularui.widget.sizer.ResizeNode;
import brachy.modularui.widget.sizer.Unit;
import brachy.modularui.widget.sizer.WidgetResizeNode;
import java.util.List;
import java.util.function.DoubleSupplier;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StandardResizer
extends WidgetResizeNode
implements IPositioned<StandardResizer> {
    private final DimensionSizer x = this.createDimensionSizer(GuiAxis.X);
    private final DimensionSizer y = this.createDimensionSizer(GuiAxis.Y);
    private boolean expanded = false;
    private boolean childrenResized = false;
    private boolean layoutResized = false;
    private boolean relativeToScreen = false;

    public StandardResizer(IWidget widget) {
        super(widget);
    }

    protected DimensionSizer createDimensionSizer(GuiAxis axis) {
        return new DimensionSizer(this, axis);
    }

    @Override
    public void initialize(ResizeNode defaultParent, ResizeNode root) {
        super.initialize(defaultParent, root);
        if (this.relativeToScreen) {
            this.setParentOverride(root);
        }
    }

    @Override
    public void initResizing(boolean onOpen) {
        this.setMarginPaddingApplied(false);
        this.setResized(false);
        this.childrenResized = false;
        this.layoutResized = false;
        super.initResizing(onOpen);
    }

    @Override
    public void reset() {
        this.x.reset();
        this.y.reset();
    }

    public void resetPosition() {
        this.x.resetPosition();
        this.y.resetPosition();
    }

    @Override
    public boolean isXCalculated() {
        return this.x.isPosCalculated();
    }

    @Override
    public boolean isYCalculated() {
        return this.y.isPosCalculated();
    }

    @Override
    public boolean isWidthCalculated() {
        return this.x.isSizeCalculated();
    }

    @Override
    public boolean isHeightCalculated() {
        return this.y.isSizeCalculated();
    }

    @Override
    public boolean areChildrenCalculated() {
        return this.childrenResized;
    }

    @Override
    public boolean isLayoutDone() {
        return this.layoutResized;
    }

    @Override
    public boolean canRelayout(boolean isParentLayout) {
        return isParentLayout && (this.x.canRelayout() || this.y.canRelayout());
    }

    @Override
    public boolean isXMarginPaddingApplied() {
        return this.x.isMarginPaddingApplied();
    }

    @Override
    public boolean isYMarginPaddingApplied() {
        return this.y.isMarginPaddingApplied();
    }

    @Override
    public StandardResizer resizer() {
        return this;
    }

    @Override
    public void scheduleResize() {
        this.markDirty();
    }

    @Override
    @ApiStatus.Internal
    public void checkExpanded(@Nullable GuiAxis axis) {
        this.x.setExpanded(false);
        this.y.setExpanded(false);
        if (this.expanded && axis != null) {
            if (axis.isHorizontal()) {
                this.x.setExpanded(true);
            } else {
                this.y.setExpanded(true);
            }
        }
    }

    @Override
    public boolean resize(boolean isParentLayout) {
        Area area = this.getArea();
        ResizeNode relativeTo = this.getParent();
        this.x.apply(area, relativeTo, () -> this.getWidget().getDefaultWidth());
        this.y.apply(area, relativeTo, () -> this.getWidget().getDefaultHeight());
        return this.isSelfFullyCalculated(isParentLayout);
    }

    @Override
    public boolean postResize() {
        boolean coverWidth = this.x.dependsOnChildren();
        boolean coverHeight = this.y.dependsOnChildren();
        if (!coverWidth && !coverHeight) {
            return this.isSelfFullyCalculated();
        }
        IWidget widget = this.getWidget();
        if (!widget.hasChildren()) {
            this.coverChildrenForEmpty();
            return this.isSelfFullyCalculated();
        }
        IWidget iWidget = this.getWidget();
        if (iWidget instanceof ILayoutWidget) {
            ILayoutWidget layout = (ILayoutWidget)((Object)iWidget);
            this.coverChildrenForLayout(layout, widget);
            return this.isSelfFullyCalculated();
        }
        List<IWidget> children = widget.getChildren();
        int moveChildrenX = 0;
        int moveChildrenY = 0;
        Box padding = this.getWidget().getArea().getPadding();
        int x0 = Integer.MAX_VALUE;
        int x1 = Integer.MIN_VALUE;
        int y0 = Integer.MAX_VALUE;
        int y1 = Integer.MIN_VALUE;
        int w = 0;
        int h = 0;
        boolean hasIndependentChildX = false;
        boolean hasIndependentChildY = false;
        for (IWidget child : children) {
            Box margin = child.getArea().getMargin();
            StandardResizer resizeable = child.resizer();
            Area area = child.getArea();
            if (coverWidth && !((ResizeNode)resizeable).dependsOnParentX()) {
                hasIndependentChildX = true;
                if (resizeable.isWidthCalculated() && resizeable.isXCalculated()) {
                    w = Math.max(w, area.requestedWidth() + padding.horizontal());
                    x0 = Math.min(x0, area.rx - padding.left() - margin.left());
                    x1 = Math.max(x1, area.rx + area.width + padding.right + margin.right);
                } else {
                    return this.isSelfFullyCalculated();
                }
            }
            if (!coverHeight || ((ResizeNode)resizeable).dependsOnParentY()) continue;
            hasIndependentChildY = true;
            if (resizeable.isHeightCalculated() && resizeable.isYCalculated()) {
                h = Math.max(h, area.requestedHeight() + padding.vertical());
                y0 = Math.min(y0, area.ry - padding.top() - margin.top());
                y1 = Math.max(y1, area.ry + area.height + padding.bottom + margin.bottom);
                continue;
            }
            return this.isSelfFullyCalculated();
        }
        if (coverWidth && !hasIndependentChildX || coverHeight && !hasIndependentChildY) {
            GuiError.throwNew(this.getWidget(), GuiError.Type.SIZING, "Can't cover children when all children depend on their parent!");
            return false;
        }
        if (x1 == Integer.MIN_VALUE) {
            x1 = 0;
        }
        if (y1 == Integer.MIN_VALUE) {
            y1 = 0;
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = 0;
        }
        if (y0 == Integer.MAX_VALUE) {
            y0 = 0;
        }
        if (w > x1 - x0) {
            x1 = x0 + w;
        }
        if (h > y1 - y0) {
            y1 = y0 + h;
        }
        Area relativeTo = this.getParent().getArea();
        if (coverWidth) {
            moveChildrenX = this.x.postApply(this.getWidget().getArea(), relativeTo, x0, x1);
        }
        if (coverHeight) {
            moveChildrenY = this.y.postApply(this.getWidget().getArea(), relativeTo, y0, y1);
        }
        if (moveChildrenX != 0 || moveChildrenY != 0) {
            for (IWidget child : children) {
                Area area = child.getArea();
                StandardResizer resizeable = child.resizer();
                if (resizeable.isXCalculated()) {
                    area.rx += moveChildrenX;
                }
                if (!resizeable.isYCalculated()) continue;
                area.ry += moveChildrenY;
            }
        }
        return this.isSelfFullyCalculated();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void coverChildrenForLayout(ILayoutWidget layout, IWidget widget) {
        List<IWidget> children = widget.getChildren();
        Box padding = this.getWidget().getArea().getPadding();
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        int w = 0;
        int h = 0;
        int withDefaultW = 0;
        int withDefaultH = 0;
        boolean coverWidth = this.x.dependsOnChildren();
        boolean coverHeight = this.y.dependsOnChildren();
        boolean hasIndependentChildX = false;
        boolean hasIndependentChildY = false;
        boolean coverByDefaultSizeX = coverWidth && layout.canCoverByDefaultSize(GuiAxis.X);
        boolean coverByDefaultSizeY = coverHeight && layout.canCoverByDefaultSize(GuiAxis.Y);
        for (IWidget child : children) {
            int s;
            if (layout.shouldIgnoreChildSize(child)) continue;
            Area area = child.getArea();
            Box margin = area.getMargin();
            StandardResizer resizeable = child.resizer();
            if (coverWidth) {
                if (!child.resizer().dependsOnParentX()) {
                    hasIndependentChildX = true;
                    if (!resizeable.isWidthCalculated()) return;
                    if (!resizeable.isXCalculated()) return;
                    s = area.requestedWidth() + padding.horizontal();
                    w = Math.max(w, s);
                    withDefaultW = Math.max(withDefaultW, s);
                    x1 = Math.max(x1, area.rx + area.width + padding.right + margin.right);
                } else if (coverByDefaultSizeX) {
                    withDefaultW = Math.max(withDefaultW, child.getDefaultWidth() + margin.horizontal() + padding.horizontal());
                }
            }
            if (!coverHeight) continue;
            if (!child.resizer().dependsOnParentY()) {
                hasIndependentChildY = true;
                if (!resizeable.isHeightCalculated()) return;
                if (!resizeable.isYCalculated()) return;
                s = area.requestedHeight() + padding.vertical();
                h = Math.max(h, s);
                withDefaultH = Math.max(withDefaultH, s);
                y1 = Math.max(y1, area.ry + area.height + padding.bottom + margin.bottom);
                continue;
            }
            if (!coverByDefaultSizeY) continue;
            withDefaultH = Math.max(withDefaultH, child.getDefaultHeight() + margin.vertical() + padding.vertical());
        }
        if (coverWidth && !hasIndependentChildX && !coverByDefaultSizeX || coverHeight && !hasIndependentChildY && !coverByDefaultSizeY) {
            GuiError.throwNew(this.getWidget(), GuiError.Type.SIZING, "Can't cover children when all children depend on their parent!");
            return;
        }
        if (w == 0) {
            w = withDefaultW;
        }
        if (h == 0) {
            h = withDefaultH;
        }
        if (x1 == Integer.MIN_VALUE) {
            x1 = 0;
        }
        if (y1 == Integer.MIN_VALUE) {
            y1 = 0;
        }
        if (w > x1) {
            x1 = w;
        }
        if (h > y1) {
            y1 = h;
        }
        Area relativeTo = this.getParent().getArea();
        if (coverWidth) {
            this.x.postApply(this.getArea(), relativeTo, 0, x1);
        }
        if (!coverHeight) return;
        this.y.postApply(this.getArea(), relativeTo, 0, y1);
    }

    private void coverChildrenForEmpty() {
        if (this.x.dependsOnChildren()) {
            this.x.coverChildrenForEmpty(this.getWidget().getArea(), this.getParent().getArea());
        }
        if (this.y.dependsOnChildren()) {
            this.y.coverChildrenForEmpty(this.getWidget().getArea(), this.getParent().getArea());
        }
    }

    @Override
    public void preApplyPos() {
        IWidget widget = this.getWidget();
        Area relativeTo = this.getParent().getArea();
        Area area = widget.getArea();
        this.x.applyMarginAndPaddingToPos(widget, area, relativeTo);
        this.y.applyMarginAndPaddingToPos(widget, area, relativeTo);
        area.applyPos(relativeTo.x, relativeTo.y);
    }

    @Override
    public void applyPos() {
        IVanillaSlot vanillaSlot;
        IDelegatingWidget dw;
        IWidget widget = this.getWidget();
        if (widget instanceof IDelegatingWidget && (dw = (IDelegatingWidget)widget).getDelegate() != null) {
            super.postFullResize();
            return;
        }
        Area area = widget.getArea();
        Area parentArea = widget.getParentArea();
        area.rx = area.x - parentArea.x;
        area.ry = area.y - parentArea.y;
        if (widget instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)((Object)widget)).handleAsVanillaSlot()) {
            SlotAccessor slot = (SlotAccessor)vanillaSlot.getVanillaSlot();
            Area mainArea = widget.getScreen().getMainPanel().getArea();
            slot.gtceu$setX(widget.getArea().x - mainArea.x + 1);
            slot.gtceu$setY(widget.getArea().y - mainArea.y + 1);
        }
    }

    @Override
    public void setChildrenResized(boolean resized) {
        this.childrenResized = resized;
    }

    @Override
    public void setLayoutDone(boolean done) {
        this.layoutResized = done;
    }

    @Override
    public void setXAxisResized(boolean pos, boolean size) {
        this.x.setResized(pos, size);
    }

    @Override
    public void setYAxisResized(boolean pos, boolean size) {
        this.y.setResized(pos, size);
    }

    @Override
    public void setXMarginPaddingApplied(boolean b) {
        this.x.setMarginPaddingApplied(b);
    }

    @Override
    public void setYMarginPaddingApplied(boolean b) {
        this.y.setMarginPaddingApplied(b);
    }

    @Override
    public boolean hasYPos() {
        return this.y.hasPos();
    }

    @Override
    public boolean hasXPos() {
        return this.x.hasPos();
    }

    @Override
    public boolean hasHeight() {
        return this.y.hasSize();
    }

    @Override
    public boolean hasWidth() {
        return this.x.hasSize();
    }

    @Override
    public boolean hasStartPos(GuiAxis axis) {
        return axis.isHorizontal() ? this.x.hasStart() : this.y.hasStart();
    }

    @Override
    public boolean hasEndPos(GuiAxis axis) {
        return axis.isHorizontal() ? this.x.hasEnd() : this.y.hasEnd();
    }

    @Override
    public boolean dependsOnParentX() {
        return this.x.dependsOnParent();
    }

    @Override
    public boolean dependsOnParentY() {
        return this.y.dependsOnParent();
    }

    @Override
    public boolean dependsOnChildrenX() {
        return this.x.dependsOnChildren();
    }

    @Override
    public boolean dependsOnChildrenY() {
        return this.y.dependsOnChildren();
    }

    @Override
    public StandardResizer expanded() {
        this.expanded = true;
        this.scheduleResize();
        return this;
    }

    @Override
    public boolean hasFixedSize() {
        return this.x.hasFixedSize() && this.y.hasFixedSize();
    }

    @Override
    public boolean isFullSize() {
        if (!this.hasHeight() || !this.hasWidth()) {
            return false;
        }
        return this.x.isFullSize() && this.y.isFullSize();
    }

    @Override
    public StandardResizer relative(ResizeNode resizeNode) {
        this.setParentOverride(resizeNode);
        this.relativeToScreen = false;
        return this;
    }

    @Override
    public StandardResizer relativeToParent() {
        this.setParentOverride(null);
        this.relativeToScreen = false;
        return this;
    }

    @Override
    public StandardResizer relativeToScreen() {
        this.relativeToScreen = true;
        return this;
    }

    @Override
    public StandardResizer coverChildren() {
        this.x.setCoverChildren(true, this.getWidget());
        this.y.setCoverChildren(true, this.getWidget());
        return this;
    }

    @Override
    public StandardResizer coverChildrenWidth() {
        this.x.setCoverChildren(true, this.getWidget());
        return this;
    }

    @Override
    public StandardResizer coverChildrenHeight() {
        this.y.setCoverChildren(true, this.getWidget());
        return this;
    }

    @ApiStatus.Internal
    public StandardResizer left(float x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getLeft(), x, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer left(DoubleSupplier x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getLeft(), x, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer right(float x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getRight(), x, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer right(DoubleSupplier x, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getRight(), x, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer top(float y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getTop(), y, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer top(DoubleSupplier y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getTop(), y, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer bottom(float y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getBottom(), y, offset, anchor, measure, autoAnchor);
    }

    @ApiStatus.Internal
    public StandardResizer bottom(DoubleSupplier y, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        return this.unit(this.getBottom(), y, offset, anchor, measure, autoAnchor);
    }

    private StandardResizer unit(Unit u, float val, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        u.setValue(val);
        u.setMeasure(measure);
        u.setOffset(offset);
        u.setAnchor(anchor);
        u.setAutoAnchor(autoAnchor);
        this.scheduleResize();
        return this;
    }

    private StandardResizer unit(Unit u, DoubleSupplier val, int offset, float anchor, Unit.Measure measure, boolean autoAnchor) {
        u.setValue(val);
        u.setMeasure(measure);
        u.setOffset(offset);
        u.setAnchor(anchor);
        u.setAutoAnchor(autoAnchor);
        this.scheduleResize();
        return this;
    }

    @ApiStatus.Internal
    public StandardResizer width(float val, int offset, Unit.Measure measure) {
        return this.unitSize(this.getWidth(), val, offset, measure);
    }

    @ApiStatus.Internal
    public StandardResizer width(DoubleSupplier val, int offset, Unit.Measure measure) {
        return this.unitSize(this.getWidth(), val, offset, measure);
    }

    @ApiStatus.Internal
    public StandardResizer height(float val, int offset, Unit.Measure measure) {
        return this.unitSize(this.getHeight(), val, offset, measure);
    }

    @ApiStatus.Internal
    public StandardResizer height(DoubleSupplier val, int offset, Unit.Measure measure) {
        return this.unitSize(this.getHeight(), val, offset, measure);
    }

    private StandardResizer unitSize(Unit u, float val, int offset, Unit.Measure measure) {
        u.setValue(val);
        u.setMeasure(measure);
        u.setOffset(offset);
        this.scheduleResize();
        return this;
    }

    private StandardResizer unitSize(Unit u, DoubleSupplier val, int offset, Unit.Measure measure) {
        u.setValue(val);
        u.setMeasure(measure);
        u.setOffset(offset);
        this.scheduleResize();
        return this;
    }

    @Override
    public StandardResizer anchorLeft(float val) {
        this.getLeft().setAnchor(val);
        this.getLeft().setAutoAnchor(false);
        this.scheduleResize();
        return this;
    }

    @Override
    public StandardResizer anchorRight(float val) {
        this.getRight().setAnchor(1.0f - val);
        this.getRight().setAutoAnchor(false);
        this.scheduleResize();
        return this;
    }

    @Override
    public StandardResizer anchorTop(float val) {
        this.getTop().setAnchor(val);
        this.getTop().setAutoAnchor(false);
        this.scheduleResize();
        return this;
    }

    @Override
    public StandardResizer anchorBottom(float val) {
        this.getBottom().setAnchor(1.0f - val);
        this.getBottom().setAutoAnchor(false);
        this.scheduleResize();
        return this;
    }

    @Override
    public StandardResizer anchor(Alignment alignment) {
        if (this.x.hasStart() || !this.x.hasEnd()) {
            this.anchorLeft(alignment.x);
        } else if (this.x.hasEnd()) {
            this.anchorRight(alignment.x);
        }
        if (this.y.hasStart() || !this.y.hasEnd()) {
            this.anchorTop(alignment.y);
        } else if (this.y.hasEnd()) {
            this.anchorBottom(alignment.y);
        }
        return this;
    }

    public void setUnit(Unit unit, GuiAxis axis, Unit.State pos) {
        (axis.isHorizontal() ? this.x : this.y).setUnit(unit, pos);
    }

    private Unit getLeft() {
        return this.x.getStart(this.getWidget());
    }

    private Unit getRight() {
        return this.x.getEnd(this.getWidget());
    }

    private Unit getTop() {
        return this.y.getStart(this.getWidget());
    }

    private Unit getBottom() {
        return this.y.getEnd(this.getWidget());
    }

    private Unit getWidth() {
        return this.x.getSize(this.getWidget());
    }

    private Unit getHeight() {
        return this.y.getSize(this.getWidget());
    }

    @Override
    @Generated
    public boolean isExpanded() {
        return this.expanded;
    }
}

