/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.scroll;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.widget.scroll.HorizontalScrollData;
import brachy.modularui.widget.scroll.ScrollArea;
import brachy.modularui.widget.scroll.ScrollData;

public class VerticalScrollData
extends ScrollData {
    public VerticalScrollData() {
        this(false, -1);
    }

    public VerticalScrollData(boolean leftAlignment) {
        this(leftAlignment, -1);
    }

    public VerticalScrollData(boolean leftAlignment, int thickness) {
        super(GuiAxis.Y, leftAlignment, thickness);
    }

    public VerticalScrollData cancelScrollEdge(boolean cancelScrollEdge) {
        this.setCancelScrollEdge(cancelScrollEdge);
        return this;
    }

    @Override
    protected int getFallbackThickness(WidgetTheme widgetTheme) {
        return widgetTheme.getDefaultWidth();
    }

    @Override
    public HorizontalScrollData getOtherScrollData(ScrollArea area) {
        return area.getScrollX();
    }

    @Override
    public boolean isInsideScrollbarArea(ScrollArea area, int x, int y) {
        if (!this.isScrollBarActive(area)) {
            return false;
        }
        int scrollbar = this.getThickness();
        HorizontalScrollData data = this.getOtherScrollData(area);
        if (data != null && this.isOtherScrollBarActive(area, true)) {
            int thickness = data.getThickness();
            if (data.isAxisStart() ? y < thickness : y >= area.h() - thickness) {
                return false;
            }
        }
        return this.isAxisStart() ? x >= 0 && x < scrollbar : x >= area.w() - scrollbar && x < area.w();
    }

    @Override
    public void drawScrollbar(GuiContext context, ScrollArea area, WidgetTheme widgetTheme, IDrawable texture) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, true);
        int l = this.getScrollBarLength(area);
        int x = this.isAxisStart() ? 0 : area.w() - this.getThickness();
        int y = 0;
        int w = this.getThickness();
        int h = area.height;
        GuiDraw.drawRect(context.getGraphics(), x, y, w, h, area.getScrollBarBackgroundColor());
        y = this.getScrollBarStart(area, l, isOtherActive);
        HorizontalScrollData data2 = this.getOtherScrollData(area);
        if (data2 != null && isOtherActive && data2.isAxisStart()) {
            y += data2.getThickness();
        }
        h = l;
        this.drawScrollBar(context, x, y, w, h, widgetTheme, texture);
    }
}

