/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.scroll;

import brachy.modularui.animation.Animator;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.Scrollbar;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Interpolation;
import brachy.modularui.widget.scroll.HorizontalScrollData;
import brachy.modularui.widget.scroll.ScrollArea;
import brachy.modularui.widget.scroll.VerticalScrollData;
import lombok.Generated;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollData {
    public static final int DEFAULT_THICKNESS = -1;
    private final GuiAxis axis;
    private final boolean axisStart;
    private final int thickness;
    private int fallbackThickness = -1;
    private int scrollSpeed = 30;
    private boolean cancelScrollEdge = true;
    private IDrawable scrollbar;
    private int scrollSize;
    private int scroll;
    protected boolean dragging;
    protected int clickOffset;
    private int animatingTo = 0;
    private final Animator scrollAnimator = new Animator().duration(500).curve(Interpolation.QUAD_OUT);

    public static ScrollData of(GuiAxis axis) {
        return ScrollData.of(axis, false, -1);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart) {
        return ScrollData.of(axis, axisStart, -1);
    }

    public static ScrollData of(GuiAxis axis, boolean axisStart, int thickness) {
        if (axis.isHorizontal()) {
            return new HorizontalScrollData(axisStart, thickness);
        }
        return new VerticalScrollData(axisStart, thickness);
    }

    protected ScrollData(GuiAxis axis, boolean axisStart, int thickness) {
        this.axis = axis;
        this.axisStart = axisStart;
        this.thickness = thickness > 0 ? Math.max(2, thickness) : -1;
    }

    public int getThickness() {
        return this.thickness > 0 ? this.thickness : this.fallbackThickness;
    }

    public boolean isVertical() {
        return this.axis.isVertical();
    }

    public boolean isHorizontal() {
        return this.axis.isHorizontal();
    }

    public final int getMinLength() {
        return this.getThickness() + 1;
    }

    protected final int getRawVisibleSize(ScrollArea area) {
        return Math.max(0, this.getRawFullVisibleSize(area) - area.getPadding().getTotal(this.axis) + area.getScrollPadding().getTotalScrollPadding(this.axis));
    }

    protected final int getRawFullVisibleSize(ScrollArea area) {
        return area.getSize(this.axis);
    }

    public final int getFullVisibleSize(ScrollArea area) {
        return this.getFullVisibleSize(area, false);
    }

    public final int getFullVisibleSize(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawFullVisibleSize(area);
        ScrollData data = this.getOtherScrollData(area);
        if (data != null && (isOtherActive || data.isScrollBarActive(area, true))) {
            s -= data.getThickness();
        }
        return s;
    }

    public final int getVisibleSize(ScrollArea area) {
        return this.getVisibleSize(area, false);
    }

    public final int getVisibleSize(ScrollArea area, int fullVisibleSize) {
        return Math.max(0, fullVisibleSize - area.getPadding().getTotal(this.axis));
    }

    public final int getVisibleSize(ScrollArea area, boolean isOtherActive) {
        return this.getVisibleSize(area, this.getFullVisibleSize(area, isOtherActive));
    }

    public float getProgress(ScrollArea area, int mainAxisPos, int crossAxisPos) {
        float fullSize = this.getFullVisibleSize(area);
        return (float)(mainAxisPos - this.clickOffset) / (fullSize - (float)this.getScrollBarLength(area));
    }

    @Nullable
    public abstract ScrollData getOtherScrollData(ScrollArea var1);

    public boolean clamp(ScrollArea area) {
        int size = this.getFullVisibleSize(area);
        int old = this.scroll;
        this.scroll = this.scrollSize <= size ? 0 : Mth.m_14045_((int)this.scroll, (int)0, (int)(this.scrollSize - size));
        return old != this.scroll;
    }

    public boolean scrollBy(ScrollArea area, int x) {
        this.scroll += x;
        return this.clamp(area);
    }

    public boolean scrollTo(ScrollArea area, int x) {
        this.scroll = x;
        return this.clamp(area);
    }

    public void animateTo(ScrollArea area, int x) {
        this.scrollAnimator.bounds(this.scroll, x).onUpdate(value -> {
            if (this.scrollTo(area, (int)value)) {
                this.scrollAnimator.stop(false);
            }
        });
        this.scrollAnimator.reset();
        this.scrollAnimator.animate();
        this.animatingTo = x;
    }

    public final boolean isScrollBarActive(ScrollArea area) {
        return this.isScrollBarActive(area, false);
    }

    public final boolean isScrollBarActive(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawFullVisibleSize(area);
        if (s < this.scrollSize) {
            return true;
        }
        ScrollData data = this.getOtherScrollData(area);
        if (data == null || s - data.getThickness() >= this.scrollSize) {
            return false;
        }
        if (isOtherActive || data.isScrollBarActive(area, true)) {
            s -= data.getThickness();
        }
        return s < this.scrollSize;
    }

    public final boolean isOtherScrollBarActive(ScrollArea area, boolean isSelfActive) {
        ScrollData data = this.getOtherScrollData(area);
        return data != null && data.isScrollBarActive(area, isSelfActive);
    }

    public int getScrollBarLength(ScrollArea area) {
        float fullSize = this.getFullVisibleSize(area);
        int length = (int)(fullSize * fullSize / (float)this.scrollSize);
        return Math.max(length, this.getMinLength());
    }

    public abstract boolean isInsideScrollbarArea(ScrollArea var1, int var2, int var3);

    public boolean isAnimating() {
        return this.scrollAnimator.isAnimating();
    }

    public int getAnimationDirection() {
        if (!this.isAnimating()) {
            return 0;
        }
        return this.scrollAnimator.getMax() >= this.scrollAnimator.getMin() ? 1 : -1;
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, int fullVisibleSize) {
        return (fullVisibleSize - scrollBarLength) * this.getScroll() / (this.getScrollSize() - fullVisibleSize);
    }

    public int getScrollBarStart(ScrollArea area, int scrollBarLength, boolean isOtherActive) {
        return this.getScrollBarStart(area, scrollBarLength, this.getFullVisibleSize(area, isOtherActive));
    }

    protected abstract int getFallbackThickness(WidgetTheme var1);

    protected final void applyWidgetTheme(WidgetTheme widgetTheme) {
        this.fallbackThickness = Math.max(2, this.getFallbackThickness(widgetTheme));
    }

    public ScrollData texture(IDrawable drawable) {
        this.scrollbar = drawable;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawScrollbar(GuiContext var1, ScrollArea var2, WidgetTheme var3, IDrawable var4);

    @OnlyIn(value=Dist.CLIENT)
    protected void drawScrollBar(GuiContext context, int x, int y, int w, int h, WidgetTheme widgetTheme, IDrawable texture) {
        IDrawable drawable = this.scrollbar != null ? this.scrollbar : (widgetTheme.getBackground() != null && widgetTheme.getBackground() != IDrawable.NONE ? widgetTheme.getBackground() : texture);
        if (drawable == null) {
            drawable = Scrollbar.DEFAULT;
        }
        drawable.draw(context, x, y, w, h, widgetTheme);
    }

    public boolean onMouseClicked(ScrollArea area, int mainAxisPos, int crossAxisPos, int button) {
        if (this.isAxisStart() ? crossAxisPos <= this.getThickness() : crossAxisPos >= area.getSize(this.axis.getOther()) - this.getThickness()) {
            this.dragging = true;
            this.clickOffset = mainAxisPos;
            int scrollBarSize = this.getScrollBarLength(area);
            int start = this.getScrollBarStart(area, scrollBarSize, false);
            boolean clickInsideBar = mainAxisPos >= start && mainAxisPos <= start + scrollBarSize;
            this.clickOffset = clickInsideBar ? mainAxisPos - start : scrollBarSize / 2;
            return true;
        }
        return false;
    }

    @Generated
    public GuiAxis getAxis() {
        return this.axis;
    }

    @Generated
    public boolean isAxisStart() {
        return this.axisStart;
    }

    @Generated
    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    @Generated
    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    @Generated
    public boolean isCancelScrollEdge() {
        return this.cancelScrollEdge;
    }

    @Generated
    public void setCancelScrollEdge(boolean cancelScrollEdge) {
        this.cancelScrollEdge = cancelScrollEdge;
    }

    @Generated
    public int getScrollSize() {
        return this.scrollSize;
    }

    @Generated
    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    @Generated
    public int getScroll() {
        return this.scroll;
    }

    @Generated
    public boolean isDragging() {
        return this.dragging;
    }

    @Generated
    public int getAnimatingTo() {
        return this.animatingTo;
    }
}

