/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.ModularUI;
import brachy.modularui.api.MCHelper;
import brachy.modularui.api.widget.ISynced;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.FormattingUtil;
import brachy.modularui.utils.TreeUtil;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.widget.InternalWidgetTree;
import brachy.modularui.widget.sizer.ResizeNode;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetTree
extends TreeUtil {
    public static boolean logResizeTime = false;
    public static final WidgetInfo WIDGET_INFO_AREA = (root, widget, builder) -> builder.append("Area xywh:").append(widget.getArea().x - root.getArea().x).append(", ").append(widget.getArea().y - root.getArea().y).append(" | ").append(widget.getArea().width).append(", ").append(widget.getArea().height).append(", rx: ").append(widget.getArea().rx).append(", ry: ").append(widget.getArea().ry);
    public static final WidgetInfo WIDGET_INFO_ENABLED = (root, widget, builder) -> builder.append("Enabled: ").append(widget.isEnabled());
    public static final WidgetInfo WIDGET_INFO_WIDGET_THEME = (root, widget, builder) -> builder.append("Widget theme: ").append(widget.getWidgetTheme(widget.getPanel().getTheme()).key().getFullName());

    private WidgetTree() {
    }

    @Nullable
    public static IWidget findFirstWithNameNullable(IWidget parent, String name) {
        return WidgetTree.foreachChildWithResult(parent, w -> w.isName(name) ? w : null, true);
    }

    @NotNull
    public static IWidget findFirstWithName(IWidget parent, String name) {
        IWidget w = WidgetTree.findFirstWithNameNullable(parent, name);
        if (w == null) {
            throw new NoSuchElementException("Expected to find widget with name '" + name + "' in sub widget tree of '" + String.valueOf(parent) + "', but non was found.");
        }
        return w;
    }

    @Nullable
    public static <T extends IWidget> T findFirstWithNameNullable(IWidget parent, String name, Class<T> type) {
        return (T)WidgetTree.foreachChildWithResult(parent, w -> w.isNameAndType(name, type) ? w : null, true);
    }

    @NotNull
    public static <T extends IWidget> T findFirstWithName(IWidget parent, String name, Class<T> type) {
        T w = WidgetTree.findFirstWithNameNullable(parent, name, type);
        if (w == null) {
            throw new NoSuchElementException("Expected to find widget with name '" + name + "' and type '" + type.getName() + "' in sub widget tree of '" + String.valueOf(parent) + "', but non was found.");
        }
        return w;
    }

    @Nullable
    public static IWidget findChildAtNullable(IWidget parent, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, IWidget.class, path, 0, true);
    }

    @NotNull
    public static IWidget findChildAt(IWidget parent, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, IWidget.class, path, 0, false);
    }

    @Nullable
    public static <T extends IWidget> T findChildAtNullable(IWidget parent, Class<T> type, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, type, path, 0, true);
    }

    @NotNull
    public static <T extends IWidget> T findChildAt(IWidget parent, Class<T> type, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Path to child must not be empty!");
        }
        return InternalWidgetTree.findChildAt(parent, type, path, 0, false);
    }

    public static boolean hasSyncedValues(ModularPanel panel) {
        return !WidgetTree.foreachChild(panel, widget -> {
            ISynced synced;
            return !(widget instanceof ISynced) || !(synced = (ISynced)((Object)widget)).isSynced();
        }, true);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel) {
        WidgetTree.collectSyncValues(syncManager, panel, true);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel, boolean includePanel) {
        WidgetTree.collectSyncValues(syncManager, panel.getName(), panel, includePanel);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, String panelName, IWidget panel, boolean includePanel) {
        MutableInt id = new MutableInt(0);
        String syncKey = "auto_sync:" + panelName;
        WidgetTree.foreachChildBFS(panel, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !synced.getSyncHandler().isRegistered()) {
                syncManager.syncValue(syncKey, id.getAndIncrement(), synced.getSyncHandler());
            }
            return true;
        }, includePanel);
    }

    public static int countUnregisteredSyncHandlers(IWidget parent) {
        MutableInt count = new MutableInt();
        WidgetTree.foreachChildBFS(parent, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !synced.getSyncHandler().isRegistered()) {
                count.increment();
            }
            return true;
        });
        return count.intValue();
    }

    public static void drawTree(IWidget parent, ModularGuiContext context) {
        WidgetTree.drawTree(parent, context, false, true);
    }

    public static void drawTree(IWidget parent, ModularGuiContext context, boolean ignoreEnabled, boolean shouldDrawBackground) {
        InternalWidgetTree.drawTree(parent, context, ignoreEnabled, shouldDrawBackground);
    }

    public static void drawTreeForeground(IWidget parent, ModularGuiContext context) {
        InternalWidgetTree.drawTreeForeground(parent, context);
    }

    @ApiStatus.Internal
    public static void onUpdate(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, widget -> {
            widget.onUpdate();
            return true;
        }, true);
    }

    @Deprecated
    public static void resize(IWidget parent) {
        parent.scheduleResize();
    }

    @ApiStatus.Internal
    public static void resizeInternal(ResizeNode parent, boolean onOpen) {
        if (!ModularUI.isClientThread()) {
            return;
        }
        long time = Util.m_137569_();
        while (parent.getParent() != null && (parent.getParent().dependsOnChildren() || parent.getParent().isLayout())) {
            parent = parent.getParent();
        }
        try {
            if (!InternalWidgetTree.resize(parent, true, onOpen, false) && !InternalWidgetTree.resize(parent, false, onOpen, false)) {
                if (MCHelper.getPlayer() != null) {
                    MCHelper.getPlayer().m_213846_((Component)Component.m_237113_((String)("MUI: Failed to resize sub tree of " + parent.getDebugDisplayName() + ". See log for more info.")));
                }
                ModularUI.LOGGER.error("Failed to resize widget. Affected resize node tree:");
                WidgetTree.print(parent, RESIZE_NODE_INFO_RESIZED_COLLAPSED);
            }
            WidgetTree.preApplyPos(parent);
            WidgetTree.applyPos(parent);
            WidgetTree.postFullResize(parent);
        }
        catch (Throwable e) {
            ModularUI.LOGGER.fatal("An exception was thrown while resizing widgets. Exception:");
            ModularUI.LOGGER.catching(e);
            ModularUI.LOGGER.fatal("Affected node tree:");
            WidgetTree.print(parent, RESIZE_NODE_INFO_RESIZED_COLLAPSED);
        }
        if (logResizeTime) {
            time = Util.m_137569_() - time;
            ModularUI.LOGGER.info("Resized widget tree in {} ns and {} ns for full resize.", (Object)FormattingUtil.formatNumbers(time), (Object)FormattingUtil.formatNumbers(time));
        }
    }

    public static void preApplyPos(ResizeNode parent) {
        parent.preApplyPos();
        for (ResizeNode resizeNode : parent.getChildren()) {
            WidgetTree.preApplyPos(resizeNode);
        }
    }

    public static void applyPos(ResizeNode parent) {
        parent.applyPos();
        for (ResizeNode resizeNode : parent.getChildren()) {
            WidgetTree.applyPos(resizeNode);
        }
    }

    public static void postFullResize(ResizeNode parent) {
        parent.postFullResize();
        for (ResizeNode resizeNode : parent.getChildren()) {
            WidgetTree.postFullResize(resizeNode);
        }
    }

    public static void verifyTree(ResizeNode parent, Set<ResizeNode> visited) {
        if (visited.contains(parent)) {
            throw new IllegalStateException("Found cycling resize node dependencies!");
        }
        visited.add(parent);
        if (!parent.getChildren().isEmpty()) {
            for (ResizeNode child : parent.getChildren()) {
                WidgetTree.verifyTree(child, visited);
            }
        }
    }

    public static interface WidgetInfo
    extends TreeUtil.NodeInfo<IWidget> {
    }
}

