/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.value.IValue;
import brachy.modularui.api.widget.IDragResizeable;
import brachy.modularui.api.widget.IGuiAction;
import brachy.modularui.api.widget.IPositioned;
import brachy.modularui.api.widget.ISynced;
import brachy.modularui.api.widget.ITooltip;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.value.sync.ISyncRegistrar;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.value.sync.ValueSyncHandler;
import brachy.modularui.widget.AbstractWidget;
import brachy.modularui.widget.sizer.StandardResizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Widget<W extends Widget<W>>
extends AbstractWidget
implements IPositioned<W>,
ITooltip<W>,
ISynced<W> {
    private boolean excludeAreaInRecipeViewer = false;
    private BiConsumer<W, IViewportStack> transform;
    @Nullable
    private IValue<?> value;
    @Nullable
    private String syncKey;
    @Nullable
    private SyncHandler syncHandler;
    @Nullable
    private final IDrawable shadow = null;
    @Nullable
    private IDrawable background = null;
    @Nullable
    private IDrawable overlay = null;
    @Nullable
    private IDrawable hoverBackground = null;
    @Nullable
    private IDrawable hoverOverlay = null;
    @Nullable
    private RichTooltip tooltip;
    @Nullable
    private WidgetThemeKey<?> widgetThemeOverride = null;
    @Nullable
    private List<IGuiAction> guiActionListeners;
    @Nullable
    private Consumer<W> onUpdateListener;

    public Widget() {
        this.resizer(new StandardResizer(this));
    }

    @Override
    void onInitInternal(boolean late) {
        if (this.guiActionListeners != null) {
            for (IGuiAction action : this.guiActionListeners) {
                this.getContext().getScreen().registerGuiActionListener(action);
            }
        }
        if (this.value != null && this.syncKey != null) {
            throw new IllegalStateException("Widget has a value and a sync key for a synced value. This is not allowed!");
        }
        if (!this.getScreen().isClientOnly()) {
            this.initialiseSyncHandler(this.getScreen().getSyncManager(), late);
        }
        if (this.isExcludeAreaInRecipeViewer()) {
            this.getContext().getRecipeViewerSettings().addExclusionArea(this);
        }
    }

    @Override
    public void initialiseSyncHandler(ModularSyncManager syncManager, boolean late) {
        ValueSyncHandler valueSyncHandler;
        SyncHandler handler = this.syncHandler;
        if (handler == null && this.syncKey != null && (handler = syncManager.getSyncHandler(this.getPanel().getName(), this.syncKey)) == null && !syncManager.getMainPSM().getPanelName().equals(this.getPanel().getName())) {
            handler = syncManager.getMainPSM().getSyncHandlerFromMapKey(this.syncKey);
        }
        if (handler != null) {
            this.setSyncOrValue(handler);
        }
        this.setSyncHandler(handler);
        SyncHandler syncHandler = this.syncHandler;
        if (syncHandler instanceof ValueSyncHandler && (valueSyncHandler = (ValueSyncHandler)syncHandler).getChangeListener() == null) {
            valueSyncHandler.setChangeListener(this::markTooltipDirty);
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.isValid()) {
            if (this.guiActionListeners != null) {
                for (IGuiAction action : this.guiActionListeners) {
                    this.getScreen().removeGuiActionListener(action);
                }
            }
            if (this.isExcludeAreaInRecipeViewer()) {
                this.getContext().getRecipeViewerSettings().removeExclusionArea(this);
            }
        }
        super.dispose();
    }

    @Override
    public void drawBackground(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        IDrawable bg;
        if (this.shadow != null) {
            this.shadow.drawAtZero(context, this.getArea().width, this.getArea().height, this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
        if ((bg = this.getCurrentBackground(this.getPanel().getTheme(), widgetTheme)) != null) {
            bg.drawAtZero(context, this.getArea().width, this.getArea().height, this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        IDrawable bg = this.getCurrentOverlay(this.getPanel().getTheme(), widgetTheme);
        if (bg != null) {
            bg.drawAtZeroPadded(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.showUpTimer())) {
            tooltip.draw(context);
        }
    }

    public IDrawable getCurrentBackground(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        IDrawable background;
        if (this.isHovering()) {
            IDrawable hoverBackground = this.getHoverBackground();
            if (hoverBackground == null) {
                hoverBackground = this.getActiveWidgetTheme(widgetTheme, true).getBackground();
            }
            if (hoverBackground != null && hoverBackground != IDrawable.NONE) {
                return hoverBackground;
            }
        }
        return (background = this.getBackground()) == null ? this.getActiveWidgetTheme(widgetTheme, false).getBackground() : background;
    }

    public IDrawable getCurrentOverlay(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        IDrawable hoverBackground = this.getHoverOverlay();
        return hoverBackground != null && hoverBackground != IDrawable.NONE && this.isHovering() ? hoverBackground : this.getOverlay();
    }

    @Override
    @NotNull
    public RichTooltip tooltip() {
        if (this.tooltip == null) {
            this.tooltip = new RichTooltip().parent(this);
        }
        return this.tooltip;
    }

    @Override
    public W tooltip(RichTooltip tooltip) {
        this.tooltip = tooltip;
        return (W)this.getThis();
    }

    public W invisible() {
        return ((Widget)this.background(IDrawable.EMPTY)).disableHoverBackground();
    }

    public void markTooltipDirty() {
        if (this.tooltip != null) {
            this.tooltip.markDirty();
        }
    }

    @ApiStatus.OverrideOnly
    protected WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getFallback();
    }

    @ApiStatus.OverrideOnly
    protected WidgetTheme getActiveWidgetTheme(WidgetThemeEntry<?> widgetTheme, boolean hover) {
        return widgetTheme.getTheme(hover);
    }

    @Override
    @ApiStatus.NonExtendable
    public final WidgetThemeEntry<?> getWidgetTheme(ITheme theme) {
        if (this.widgetThemeOverride != null) {
            return theme.getWidgetTheme(this.widgetThemeOverride);
        }
        return this.getWidgetThemeInternal(theme);
    }

    @ApiStatus.NonExtendable
    public final <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(ITheme theme, Class<T> expectedType) {
        WidgetThemeEntry<?> entry = this.getWidgetTheme(theme);
        if (entry.key().isOfType(expectedType)) {
            return entry;
        }
        throw new IllegalStateException(String.format("Got widget theme with invalid type in widget '%s'. Got type '%s', but expected type '%s'!", this, entry.key().getWidgetThemeType().getSimpleName(), expectedType.getSimpleName()));
    }

    public W background(IDrawable ... background) {
        this.background = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W overlay(IDrawable ... overlay) {
        this.overlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W hoverBackground(IDrawable ... background) {
        this.hoverBackground = IDrawable.of(background);
        return (W)this.getThis();
    }

    public W hoverOverlay(IDrawable ... overlay) {
        this.hoverOverlay = IDrawable.of(overlay);
        return (W)this.getThis();
    }

    public W disableHoverBackground() {
        return this.hoverBackground(IDrawable.NONE);
    }

    public W disableHoverOverlay() {
        return this.hoverOverlay(IDrawable.NONE);
    }

    public W widgetTheme(String s) {
        WidgetThemeKey<?> widgetThemeKey = WidgetThemeKey.getFromFullName(s);
        if (widgetThemeKey == null) {
            throw new IllegalArgumentException("No widget theme for id '" + s + "' exists.");
        }
        return this.widgetTheme(widgetThemeKey);
    }

    public W widgetTheme(WidgetThemeKey<?> s) {
        this.widgetThemeOverride = s;
        return (W)this.getThis();
    }

    @Override
    @MustBeInvokedByOverriders
    public void onUpdate() {
        super.onUpdate();
        if (this.onUpdateListener != null) {
            this.onUpdateListener.accept(this.getThis());
        }
    }

    public W listenGuiAction(IGuiAction action) {
        if (this.guiActionListeners == null) {
            this.guiActionListeners = new ArrayList<IGuiAction>();
        }
        this.guiActionListeners.add(action);
        if (this.isValid()) {
            this.getScreen().registerGuiActionListener(action);
        }
        return (W)this.getThis();
    }

    public W onUpdateListener(Consumer<W> listener) {
        return this.onUpdateListener(listener, false);
    }

    public W onUpdateListener(Consumer<W> listener, boolean merge) {
        if (merge && this.onUpdateListener != null) {
            Consumer oldListener = this.onUpdateListener;
            if (listener != null) {
                this.onUpdateListener = w -> {
                    oldListener.accept(w);
                    listener.accept(w);
                };
            }
        } else {
            this.onUpdateListener = listener;
        }
        return (W)this.getThis();
    }

    public W setEnabledIf(Predicate<W> condition) {
        return (W)this.onUpdateListener(w -> this.setEnabled(condition.test(w)), true);
    }

    @Override
    public int getDefaultWidth() {
        return this.isValid() ? ((WidgetTheme)this.getWidgetTheme(this.getPanel().getTheme()).theme()).getDefaultWidth() : 18;
    }

    @Override
    public int getDefaultHeight() {
        return this.isValid() ? ((WidgetTheme)this.getWidgetTheme(this.getPanel().getTheme()).theme()).getDefaultHeight() : 18;
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.transform != null) {
            this.transform.accept(this.getThis(), stack);
        }
    }

    public W transform(BiConsumer<W, IViewportStack> transform) {
        this.transform = transform;
        return (W)this.getThis();
    }

    @Override
    public boolean isSynced() {
        return this.syncHandler != null;
    }

    @Override
    @NotNull
    public SyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised or not synced!");
        }
        return this.syncHandler;
    }

    @Override
    public W syncHandler(String name, int id) {
        this.syncKey = ISyncRegistrar.makeSyncKey(name, id);
        return (W)this.getThis();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    protected void setValue(IValue<?> value) {
        this.value = value;
        if (value instanceof SyncHandler) {
            SyncHandler handler = (SyncHandler)((Object)value);
            this.setSyncHandler(handler);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    protected void setSyncHandler(@Nullable SyncHandler syncHandler) {
        if (syncHandler != null) {
            this.checkValidSyncOrValue(syncHandler);
        }
        this.syncHandler = syncHandler;
    }

    @MustBeInvokedByOverriders
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        if (!syncOrValue.isSyncHandler() && !syncOrValue.isValueHandler()) {
            return;
        }
        this.checkValidSyncOrValue(syncOrValue);
        if (syncOrValue instanceof SyncHandler) {
            SyncHandler syncHandler1 = (SyncHandler)syncOrValue;
            this.setSyncHandler(syncHandler1);
        }
        if (syncOrValue instanceof IValue) {
            IValue value1 = (IValue)syncOrValue;
            this.setValue(value1);
        }
    }

    public W excludeAreaInRecipeViewer() {
        return this.excludeAreaInRecipeViewer(true);
    }

    public W excludeAreaInRecipeViewer(boolean val) {
        this.excludeAreaInRecipeViewer = val;
        if (this.isValid()) {
            this.getContext().getRecipeViewerSettings().addExclusionArea(this);
        }
        return (W)this.getThis();
    }

    public W disabled() {
        this.setEnabled(false);
        return (W)this.getThis();
    }

    @Override
    public Object getAdditionalHoverInfo(IViewportStack viewportStack, int mouseX, int mouseY) {
        Widget widget = this;
        if (widget instanceof IDragResizeable) {
            IDragResizeable dragResizeable = (IDragResizeable)((Object)widget);
            return IDragResizeable.getDragResizeCorner(dragResizeable, this.getArea(), viewportStack, mouseX, mouseY);
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public W debugName(String name) {
        return this.name(name);
    }

    public W name(String name) {
        this.setName(name);
        return (W)this.getThis();
    }

    @Override
    public W getThis() {
        return (W)this;
    }

    @Generated
    public boolean isExcludeAreaInRecipeViewer() {
        return this.excludeAreaInRecipeViewer;
    }

    @Nullable
    @Generated
    public IValue<?> getValue() {
        return this.value;
    }

    @Nullable
    @Generated
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    @Generated
    public IDrawable getOverlay() {
        return this.overlay;
    }

    @Nullable
    @Generated
    public IDrawable getHoverBackground() {
        return this.hoverBackground;
    }

    @Nullable
    @Generated
    public IDrawable getHoverOverlay() {
        return this.hoverOverlay;
    }

    @Override
    @Nullable
    @Generated
    public RichTooltip getTooltip() {
        return this.tooltip;
    }

    @Nullable
    @Generated
    public WidgetThemeKey<?> getWidgetThemeOverride() {
        return this.widgetThemeOverride;
    }

    @Nullable
    @Generated
    public Consumer<W> getOnUpdateListener() {
        return this.onUpdateListener;
    }
}

