/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.ResizeNode;
import brachy.modularui.widgets.layout.IExpander;
import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Contract;

public class InternalWidgetTree {
    @Contract(value="_,_,_,_,false -> !null")
    static <T extends IWidget> T findChildAt(IWidget parent, Class<T> type, String[] path, int index, boolean nullable) {
        String current = path[index];
        boolean isLast = index == path.length - 1;
        for (IWidget widget : parent.getChildren()) {
            if (!widget.isName(current)) continue;
            if (isLast) {
                if (!widget.isType(type)) {
                    throw new ClassCastException("Found widget at '" + Joiner.on((char)'/').join((Object[])Arrays.copyOfRange(path, 0, index + 1)) + "' with type '" + widget.getClass().getName() + "', but expected type '" + type.getName() + "'.");
                }
                return (T)widget;
            }
            T result = InternalWidgetTree.findChildAt(widget, type, path, index + 1, nullable);
            if (result == null) continue;
            return result;
        }
        if (!nullable) {
            throw new NoSuchElementException("Expected to find widget at '" + Joiner.on((char)'/').join((Object[])Arrays.copyOfRange(path, 0, index + 1)) + "', but none was found.");
        }
        return null;
    }

    static void drawTree(IWidget parent, ModularGuiContext context, boolean ignoreEnabled, boolean shouldDrawBackground) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        if (parent.requiresResize()) {
            WidgetTree.resizeInternal(parent.resizer(), false);
        }
        GuiGraphics graphics = context.getGraphics();
        float alpha = parent.getPanel().getAlpha();
        IViewport viewport = parent instanceof IViewport ? (IViewport)parent : null;
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        graphics.m_280168_().m_85836_();
        context.applyTo(graphics.m_280168_());
        if (canBeSeen) {
            graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(parent.getPanel().getTheme());
            if (shouldDrawBackground) {
                parent.drawBackground(context, widgetTheme);
            }
            parent.draw(context, widgetTheme);
            parent.drawOverlay(context, widgetTheme);
        }
        if (viewport != null) {
            if (canBeSeen) {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
                viewport.preDraw(context, false);
                graphics.m_280168_().m_85849_();
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
                graphics.m_280168_().m_85836_();
                context.applyTo(graphics.m_280168_());
                viewport.preDraw(context, true);
            } else {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
        }
        graphics.m_280168_().m_85849_();
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            boolean backgroundSeparate;
            boolean bl = backgroundSeparate = children.size() > 1;
            if (backgroundSeparate) {
                children.forEach(widget -> InternalWidgetTree.drawBackground(widget, context, ignoreEnabled));
            }
            children.forEach(widget -> InternalWidgetTree.drawTree(widget, context, false, !backgroundSeparate));
        }
        if (viewport != null) {
            if (canBeSeen) {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
                graphics.m_280168_().m_85836_();
                context.applyTo(graphics.m_280168_());
                viewport.postDraw(context, true);
                context.popViewport(viewport);
                graphics.m_280168_().m_85849_();
                graphics.m_280168_().m_85836_();
                context.applyTo(graphics.m_280168_());
                viewport.postDraw(context, false);
                graphics.m_280168_().m_85849_();
            } else {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    static void drawBackground(IWidget parent, ModularGuiContext context, boolean ignoreEnabled) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        GuiGraphics graphics = context.getGraphics();
        float alpha = parent.getPanel().getAlpha();
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        if (!canBeSeen) {
            context.popMatrix();
            return;
        }
        graphics.m_280168_().m_85836_();
        context.applyTo(graphics.m_280168_());
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(parent.getPanel().getTheme());
        parent.drawBackground(context, widgetTheme);
        graphics.m_280168_().m_85849_();
        context.popMatrix();
    }

    static void drawTreeForeground(IWidget parent, ModularGuiContext context) {
        IViewport viewport1;
        IViewport viewport = parent instanceof IViewport ? (viewport1 = (IViewport)parent) : null;
        context.pushMatrix();
        parent.transform(context);
        context.getGraphics().m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        parent.drawForeground(context);
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            if (viewport != null) {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
            children.forEach(widget -> InternalWidgetTree.drawTreeForeground(widget, context));
            if (viewport != null) {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    static boolean resize(ResizeNode resizer, boolean init, boolean onOpen, boolean isParentLayout) {
        boolean shouldLayout;
        GuiAxis guiAxis;
        boolean selfFullyCalculated;
        boolean alreadyCalculated = false;
        boolean isLayout = resizer.isLayout();
        if (init) {
            resizer.initResizing(onOpen);
            if (!isLayout) {
                resizer.setLayoutDone(true);
            }
        } else {
            alreadyCalculated = resizer.isFullyCalculated(isParentLayout);
        }
        boolean bl = selfFullyCalculated = resizer.isSelfFullyCalculated() || resizer.resize(isParentLayout);
        if (resizer instanceof IExpander) {
            IExpander expander = (IExpander)((Object)resizer);
            guiAxis = expander.getExpandAxis();
        } else {
            guiAxis = null;
        }
        GuiAxis expandAxis = guiAxis;
        List<ResizeNode> anotherResize = Collections.emptyList();
        if (!resizer.areChildrenCalculated() && !resizer.getChildren().isEmpty()) {
            anotherResize = new ArrayList();
            for (ResizeNode child : resizer.getChildren()) {
                if (init) {
                    child.checkExpanded(expandAxis);
                }
                if (InternalWidgetTree.resize(child, init, onOpen, isLayout)) continue;
                anotherResize.add(child);
            }
        }
        boolean bl2 = shouldLayout = init || !resizer.areChildrenCalculated() || !resizer.isLayoutDone();
        if (shouldLayout || !selfFullyCalculated) {
            boolean layoutSuccessful = true;
            BitSet state = InternalWidgetTree.getCalculatedState(anotherResize, isLayout);
            if (isLayout && shouldLayout) {
                layoutSuccessful = resizer.layoutChildren();
            }
            resizer.postResize();
            if (isLayout && shouldLayout) {
                layoutSuccessful &= resizer.postLayoutChildren();
                if (!selfFullyCalculated) {
                    resizer.postResize();
                }
            }
            if (shouldLayout) {
                resizer.setLayoutDone(layoutSuccessful);
            }
            InternalWidgetTree.checkFullyCalculated(anotherResize, state, isLayout);
        }
        if (!anotherResize.isEmpty()) {
            for (int i = 0; i < anotherResize.size(); ++i) {
                if (!InternalWidgetTree.resize(anotherResize.get(i), false, onOpen, isLayout)) continue;
                anotherResize.remove(i--);
            }
        }
        resizer.setChildrenResized(anotherResize.isEmpty());
        selfFullyCalculated = resizer.isFullyCalculated(isParentLayout);
        if (selfFullyCalculated && !alreadyCalculated) {
            resizer.onResized();
        }
        return selfFullyCalculated;
    }

    private static BitSet getCalculatedState(List<ResizeNode> children, boolean isLayout) {
        if (children.isEmpty()) {
            return null;
        }
        BitSet state = new BitSet();
        for (int i = 0; i < children.size(); ++i) {
            ResizeNode widget = children.get(i);
            if (!widget.isFullyCalculated(isLayout)) continue;
            state.set(i);
        }
        return state;
    }

    private static void checkFullyCalculated(List<ResizeNode> children, BitSet state, boolean isLayout) {
        if (children.isEmpty() || state == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < children.size(); ++i) {
            ResizeNode widget = children.get(i);
            if (!state.get(j) && widget.isFullyCalculated(isLayout)) {
                widget.onResized();
                state.set(j);
                children.remove(i--);
            }
            ++j;
        }
    }
}

