/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IDelegatingWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.utils.MutableSingletonList;
import brachy.modularui.widget.AbstractWidget;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DelegatingWidget
extends AbstractWidget
implements IDelegatingWidget {
    private final MutableSingletonList<IWidget> delegate = new MutableSingletonList();

    public DelegatingWidget(IWidget delegate) {
        this.delegate.set(delegate);
        this.resizer(new StandardResizer(this));
    }

    protected void setDelegate(IWidget delegate) {
        if (!this.delegate.isEmpty()) {
            this.delegate.get().dispose();
            this.delegate.remove();
        }
        if (delegate != null) {
            this.delegate.set(delegate);
            if (this.isValid()) {
                this.initialise(this.getParent(), true);
                delegate.scheduleResize();
            }
            this.onChangeDelegate(delegate);
        }
    }

    protected void onChangeDelegate(IWidget delegate) {
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return this.delegate;
    }

    @Override
    public void afterInit() {
        super.resizer().setDefaultParent(null);
        if (this.hasChildren()) {
            this.getDelegate().resizer().setDefaultParentIsDelegating(true);
            this.getDelegate().resizer().relative(this.getParent());
        }
    }

    @Override
    public void postResize() {
        super.postResize();
        if (this.getDelegate() != null) {
            Area childArea = this.getDelegate().getArea();
            Area area = super.getArea();
            area.set(childArea);
            area.rx = childArea.rx;
            area.ry = childArea.ry;
            childArea.rx = 0;
            childArea.ry = 0;
        }
    }

    @Override
    @NotNull
    public StandardResizer resizer() {
        return this.getDelegate() != null ? this.getDelegate().resizer() : super.resizer();
    }

    @Override
    public Area getArea() {
        return this.getDelegate() != null ? this.getDelegate().getArea() : super.getArea();
    }

    @Override
    public void transform(IViewportStack stack) {
        stack.translate(super.getArea().rx, super.getArea().ry, 0.0f);
    }

    @Override
    public boolean canBeSeen(IViewportStack stack) {
        return false;
    }

    @Override
    public boolean requiresResize() {
        return this.getDelegate() != null && this.getDelegate().requiresResize();
    }

    @Override
    public int getDefaultWidth() {
        return this.getDelegate() != null ? this.getDelegate().getDefaultWidth() : super.getDefaultWidth();
    }

    @Override
    public int getDefaultHeight() {
        return this.getDelegate() != null ? this.getDelegate().getDefaultHeight() : super.getDefaultHeight();
    }

    @Override
    public IWidget getDelegate() {
        return this.delegate.getOrNull();
    }
}

