/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.widget.IDelegatingWidget;
import brachy.modularui.api.widget.INotifyEnabled;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWidget
implements IWidget {
    private boolean valid = false;
    private IWidget parent = null;
    private ModularPanel panel = null;
    private ModularGuiContext context = null;
    @Nullable
    private String name;
    private boolean enabled = true;
    private int timeHovered = -1;
    private int timeBelowMouse = -1;
    private final Area area = new Area();
    private StandardResizer resizer;

    @Override
    public ModularScreen getScreen() {
        return this.getPanel().getScreen();
    }

    @Override
    public void scheduleResize() {
        this.resizer.markDirty();
    }

    @Override
    public boolean requiresResize() {
        return this.resizer.requiresResize();
    }

    @Override
    @ApiStatus.Internal
    public final void initialise(@NotNull IWidget parent, boolean late) {
        this.timeHovered = -1;
        this.timeBelowMouse = -1;
        if (this.resizer == null) {
            throw new IllegalStateException("Resizer must be set before the widget initializes! Affected widget: " + String.valueOf(this));
        }
        if (!(this instanceof ModularPanel)) {
            this.parent = parent;
            this.panel = parent.getPanel();
            this.context = parent.getContext();
            this.getArea().z(parent.getArea().z() + 1);
            if (parent instanceof AbstractWidget) {
                AbstractWidget aw = (AbstractWidget)parent;
                this.resizer.initialize(aw.resizer, parent.getScreen().getResizeNode());
            } else {
                this.resizer.initialize(parent.resizer(), parent.getScreen().getResizeNode());
            }
        }
        this.valid = true;
        this.onInitInternal(late);
        this.onInit();
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.initialise(this, false);
            }
        }
        this.afterInit();
        this.onResized();
    }

    void onInitInternal(boolean late) {
    }

    @ApiStatus.OverrideOnly
    public void onInit() {
    }

    @ApiStatus.OverrideOnly
    public void afterInit() {
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.hasChildren()) {
            for (IWidget child : this.getChildren()) {
                child.dispose();
            }
        }
        if (!(this instanceof ModularPanel)) {
            this.panel = null;
            this.parent = null;
            this.context = null;
        }
        this.resizer().dispose();
        this.timeHovered = -1;
        this.timeBelowMouse = -1;
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void onUpdate() {
        if (this.isHovering()) {
            ++this.timeHovered;
        }
        if (this.isBelowMouse()) {
            ++this.timeBelowMouse;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void onMouseStartHover() {
        this.timeHovered = 0;
    }

    @Override
    @MustBeInvokedByOverriders
    public void onMouseEndHover() {
        this.timeHovered = -1;
    }

    @Override
    @MustBeInvokedByOverriders
    public void onMouseEnterArea() {
        this.timeBelowMouse = 0;
    }

    @Override
    @MustBeInvokedByOverriders
    public void onMouseLeaveArea() {
        this.timeBelowMouse = -1;
    }

    @Override
    public boolean isHoveringFor(int ticks) {
        return this.timeHovered >= ticks;
    }

    @Override
    public boolean isBelowMouseFor(int ticks) {
        return this.timeBelowMouse >= ticks;
    }

    public int getTicksHovered() {
        return this.timeHovered;
    }

    public int getTicksBelowMouse() {
        return this.timeBelowMouse;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public Area getParentArea() {
        IWidget parent = this.getParent();
        while (parent instanceof IDelegatingWidget) {
            IDelegatingWidget dw = (IDelegatingWidget)parent;
            parent = dw.getParent();
        }
        return parent.getArea();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            IWidget iWidget;
            this.enabled = enabled;
            if (this.isValid() && (iWidget = this.getParent()) instanceof INotifyEnabled) {
                INotifyEnabled notifyEnabled = (INotifyEnabled)((Object)iWidget);
                notifyEnabled.onChildChangeEnabled(this, enabled);
            }
        }
    }

    @Override
    @NotNull
    public IWidget getParent() {
        if (!this.isValid()) {
            throw new IllegalStateException(String.valueOf(this) + " is not in a valid state!");
        }
        return this.parent;
    }

    @Override
    public ModularGuiContext getContext() {
        if (!this.isValid()) {
            throw new IllegalStateException(String.valueOf(this) + " is not in a valid state!");
        }
        return this.context;
    }

    @ApiStatus.Internal
    protected final void setContext(ModularGuiContext context) {
        this.context = context;
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        if (!this.isValid()) {
            throw new IllegalStateException(String.valueOf(this) + " is not in a valid state!");
        }
        return this.panel;
    }

    @Override
    @NotNull
    public StandardResizer resizer() {
        return this.resizer;
    }

    protected final StandardResizer rawResizer() {
        return this.resizer;
    }

    protected void resizer(StandardResizer resizer) {
        Objects.requireNonNull(resizer);
        if (this.resizer == resizer) {
            return;
        }
        if (this.isValid() && this.resizer != null) {
            resizer.replacementOf(this.resizer);
        }
        this.resizer = resizer;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isName(String name) {
        return Objects.equals(name, this.name);
    }

    public boolean nameContains(String part) {
        return this.name != null && this.name.contains(part);
    }

    protected String getTypeName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getTypeName() + "#" + this.getName();
        }
        return this.getTypeName();
    }
}

