/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.value.sync.IStringSyncValue;
import brachy.modularui.utils.NetworkUtils;
import brachy.modularui.value.sync.AbstractGenericSyncValue;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringSyncValue
extends AbstractGenericSyncValue<String>
implements IStringSyncValue<String> {
    public StringSyncValue(Supplier<String> getter, Consumer<String> setter) {
        super(String.class, getter, setter);
    }

    public StringSyncValue(@NotNull Supplier<String> getter) {
        this(getter, (Consumer<String>)null);
    }

    @Contract(value="null, null -> fail")
    public StringSyncValue(@Nullable Supplier<String> clientGetter, @Nullable Supplier<String> serverGetter) {
        this(clientGetter, null, serverGetter, null);
    }

    @Contract(value="null, _, null, _ -> fail")
    public StringSyncValue(@Nullable Supplier<String> clientGetter, @Nullable Consumer<String> clientSetter, @Nullable Supplier<String> serverGetter, @Nullable Consumer<String> serverSetter) {
        super(String.class, clientGetter, clientSetter, serverGetter, serverSetter);
    }

    @Override
    protected String createDeepCopyOf(String value) {
        return value;
    }

    @Override
    protected boolean areEqual(String a, String b) {
        return Objects.equals(a, b);
    }

    @Override
    protected void serialize(FriendlyByteBuf buffer, String value) {
        NetworkUtils.writeStringSafe(buffer, value, 32693);
    }

    @Override
    protected String deserialize(FriendlyByteBuf buffer) {
        return NetworkUtils.readStringSafe(buffer);
    }

    @Override
    public String getStringValue() {
        return (String)this.getValue();
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setValue(value, setSource, sync);
    }
}

