/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.ISyncedAction;
import brachy.modularui.network.ModularNetwork;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.value.sync.ISyncRegistrar;
import brachy.modularui.value.sync.ModularSyncManager;
import brachy.modularui.value.sync.PanelSyncHandler;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.value.sync.SyncedAction;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.SlotGroup;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PanelSyncManager
implements ISyncRegistrar<PanelSyncManager> {
    private final Map<String, SyncHandler> syncHandlers = new Object2ReferenceLinkedOpenHashMap();
    private final Map<String, SlotGroup> slotGroups = new Object2ReferenceOpenHashMap();
    private final Map<SyncHandler, String> reverseSyncHandlers = new Object2ReferenceOpenHashMap();
    private final Map<String, SyncedAction> syncedActions = new Object2ReferenceOpenHashMap();
    private final Map<String, PanelSyncHandler> subPanels = new Object2ReferenceArrayMap();
    private final ModularSyncManager modularSyncManager;
    private String panelName;
    private boolean init = true;
    private boolean locked = false;
    private boolean allowSyncHandlerRegistration = false;
    private final boolean client;
    private final List<Consumer<Player>> openListener = new ArrayList<Consumer<Player>>();
    private final List<Consumer<Player>> closeListener = new ArrayList<Consumer<Player>>();
    private final List<Runnable> tickListener = new ArrayList<Runnable>();

    @ApiStatus.Internal
    public PanelSyncManager(ModularSyncManager msm, boolean main) {
        this.modularSyncManager = msm;
        this.client = msm.isClient();
        if (main) {
            msm.setMainPSM(this);
        }
    }

    @ApiStatus.Internal
    public void initialize(String panelName) {
        this.panelName = panelName;
        this.syncHandlers.forEach((mapKey, syncHandler) -> syncHandler.init((String)mapKey, this));
        this.locked = true;
        this.init = true;
        this.subPanels.forEach((s, syncHandler) -> this.modularSyncManager.getMainPSM().registerPanelSyncHandler((String)s, (SyncHandler)syncHandler));
    }

    private void registerPanelSyncHandler(String name, SyncHandler syncHandler) {
        SyncHandler currentSh = this.syncHandlers.get(name);
        if (currentSh != null && currentSh != syncHandler) {
            throw new IllegalStateException("Failed to register panel sync handler during initialization. There already exists a sync handler for the name '" + name + "'.");
        }
        String currentName = this.reverseSyncHandlers.get(syncHandler);
        if (currentName != null && !name.equals(currentName)) {
            throw new IllegalStateException("Failed to register panel sync handler for name '" + name + "' during initialization. The panel sync handler is already registered under the name '" + currentName + "'.");
        }
        this.syncHandlers.put(name, syncHandler);
        this.reverseSyncHandlers.put(syncHandler, name);
        syncHandler.init(name, this);
    }

    void closeSubPanels() {
        this.subPanels.values().forEach(syncHandler -> {
            if (syncHandler.isSubPanel()) {
                syncHandler.closePanel();
            }
        });
    }

    @ApiStatus.Internal
    public void onOpen() {
        this.openListener.forEach(listener -> listener.accept(this.getPlayer()));
    }

    @ApiStatus.Internal
    public void onClose() {
        this.closeListener.forEach(listener -> listener.accept(this.getPlayer()));
        this.syncHandlers.values().forEach(SyncHandler::dispose);
    }

    public boolean isInitialised() {
        return this.panelName != null;
    }

    void detectAndSendChanges(boolean init) {
        if (!this.isClient()) {
            for (SyncHandler syncHandler : this.syncHandlers.values()) {
                syncHandler.detectAndSendChanges(init || this.init);
            }
        }
        this.init = false;
    }

    void onUpdate() {
        this.tickListener.forEach(Runnable::run);
    }

    @ApiStatus.Internal
    public void receiveWidgetUpdate(String mapKey, boolean action, int id, FriendlyByteBuf buf) {
        if (action) {
            this.invokeSyncedAction(mapKey, buf);
            return;
        }
        if (!this.syncHandlers.containsKey(mapKey)) {
            ModularUI.LOGGER.warn("SyncHandler '{}' does not exist for panel '{}'! ID was {}.", (Object)mapKey, (Object)this.panelName, (Object)id);
            return;
        }
        SyncHandler syncHandler = this.syncHandlers.get(mapKey);
        if (this.isClient()) {
            syncHandler.readOnClient(id, buf);
        } else {
            syncHandler.readOnServer(id, buf);
        }
    }

    private boolean invokeSyncedAction(String mapKey, FriendlyByteBuf buf) {
        SyncedAction syncedAction = this.syncedActions.get(mapKey);
        if (syncedAction == null) {
            ModularUI.LOGGER.warn("SyncAction '{}' does not exist for panel '{}'!.", (Object)mapKey, (Object)this.panelName);
            return false;
        }
        if (!this.isLocked() || this.allowSyncHandlerRegistration || !syncedAction.isExecuteClient() || !syncedAction.isExecuteServer()) {
            syncedAction.invoke(this.client, buf);
        } else {
            this.allowTemporarySyncHandlerRegistration(true);
            syncedAction.invoke(this.client, buf);
            this.allowTemporarySyncHandlerRegistration(false);
        }
        return syncedAction.isExecute(!this.client);
    }

    public ItemStack getCursorItem() {
        return this.getModularSyncManager().getCursorItem();
    }

    public void setCursorItem(ItemStack stack) {
        this.getModularSyncManager().setCursorItem(stack);
    }

    @Override
    public boolean hasSyncHandler(SyncHandler syncHandler) {
        return syncHandler.isValid() && syncHandler.getSyncManager() == this && this.reverseSyncHandlers.containsKey(syncHandler);
    }

    private void putSyncValue(String name, int id, SyncHandler syncHandler) {
        if (this.isLocked()) {
            if (this.allowSyncHandlerRegistration) {
                throw new IllegalStateException("SyncHandlers must be registered during panel building. Please use getOrCreateSyncHandler() inside DynamicSyncHandler!");
            }
            throw new IllegalStateException("SyncHandlers must be registered during panel building. The only exceptions is via a DynamicSyncHandler and sync functions!");
        }
        String key = PanelSyncManager.makeSyncKey(name, id);
        String currentKey = this.reverseSyncHandlers.get(syncHandler);
        if (currentKey != null) {
            if (!currentKey.equals(key)) {
                boolean auto = name.startsWith("auto_sync:");
                if (auto != currentKey.startsWith("auto_sync:")) {
                    throw new IllegalStateException("Old and new sync handler must both be either not auto or auto!");
                }
                if (auto && !currentKey.startsWith(name)) {
                    throw new IllegalStateException("Sync Handler was previously added with a different panel!");
                }
            }
            this.syncHandlers.remove(currentKey);
        }
        this.syncHandlers.put(key, syncHandler);
        this.reverseSyncHandlers.put(syncHandler, key);
        if (this.isInitialised()) {
            syncHandler.init(key, this);
        }
    }

    @Override
    public PanelSyncManager syncValue(String name, int id, SyncHandler syncHandler) {
        Objects.requireNonNull(name, "Name must not be null");
        Objects.requireNonNull(syncHandler, "Sync Handler must not be null");
        this.putSyncValue(name, id, syncHandler);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.3.0")
    public IPanelHandler panel(String key, PanelSyncHandler.IPanelBuilder panelBuilder, boolean subPanel) {
        SyncHandler sh = this.subPanels.get(key);
        if (sh != null) {
            return (IPanelHandler)((Object)sh);
        }
        PanelSyncHandler syncHandler = new PanelSyncHandler(panelBuilder, subPanel);
        this.subPanels.put(key, syncHandler);
        return syncHandler;
    }

    @Override
    public IPanelHandler syncedPanel(String key, boolean subPanel, PanelSyncHandler.IPanelBuilder panelBuilder) {
        IPanelHandler ph = this.findPanelHandlerNullable(key);
        if (ph != null) {
            return ph;
        }
        if (this.isLocked() && !this.allowSyncHandlerRegistration) {
            throw new IllegalStateException("Synced panels must be registered during panel building. The only exceptions is via a DynamicSyncHandler and sync functions!");
        }
        PanelSyncHandler syncHandler = new PanelSyncHandler(panelBuilder, subPanel);
        this.subPanels.put(key, syncHandler);
        if (this.isInitialised() && (this == this.modularSyncManager.getMainPSM() || this.modularSyncManager.getMainPSM().findSyncHandlerNullable(this.panelName, PanelSyncHandler.class) == null)) {
            this.modularSyncManager.getMainPSM().registerPanelSyncHandler(key, syncHandler);
        }
        return syncHandler;
    }

    @Override
    @Nullable
    public IPanelHandler findPanelHandlerNullable(String key) {
        return this.subPanels.get(key);
    }

    @Override
    public PanelSyncManager registerSlotGroup(SlotGroup slotGroup) {
        if (!slotGroup.isSingleton()) {
            this.slotGroups.put(slotGroup.getName(), slotGroup);
        }
        return this;
    }

    public PanelSyncManager addOpenListener(Consumer<Player> listener) {
        this.openListener.add(listener);
        return this;
    }

    public PanelSyncManager addCloseListener(Consumer<Player> listener) {
        this.closeListener.add(listener);
        return this;
    }

    public PanelSyncManager onClientTick(Runnable runnable) {
        if (this.client) {
            this.tickListener.add(runnable);
        }
        return this;
    }

    public PanelSyncManager onServerTick(Runnable runnable) {
        if (!this.client) {
            this.tickListener.add(runnable);
        }
        return this;
    }

    public PanelSyncManager onCommonTick(Runnable runnable) {
        this.tickListener.add(runnable);
        return this;
    }

    @Override
    public PanelSyncManager registerSyncedAction(String mapKey, boolean executeClient, boolean executeServer, ISyncedAction action) {
        if (executeClient || executeServer) {
            this.syncedActions.put(mapKey, new SyncedAction(action, executeClient, executeServer));
        }
        return this;
    }

    public void callSyncedAction(String mapKey, FriendlyByteBuf packet) {
        if (this.invokeSyncedAction(mapKey, packet)) {
            ModularNetwork.get(this.isClient()).sendActionPacket(this.getModularSyncManager(), this.panelName, mapKey, packet, this.getPlayer());
        }
    }

    public void callSyncedAction(String mapKey, Consumer<FriendlyByteBuf> packetBuilder) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packetBuilder.accept(packet);
        this.callSyncedAction(mapKey, packet);
    }

    public void callSyncedAction(String mapKey) {
        this.callSyncedAction(mapKey, new FriendlyByteBuf(Unpooled.buffer((int)0)));
    }

    @Override
    public <T extends SyncHandler> T getOrCreateSyncHandler(String name, int id, Class<T> clazz, Supplier<T> supplier) {
        SyncHandler syncHandler = this.findSyncHandlerNullable(name, id);
        if (syncHandler == null) {
            if (this.isLocked() && !this.allowSyncHandlerRegistration) {
                throw new IllegalStateException("SyncHandlers must be registered during panel building. The only exceptions is via a DynamicSyncHandler and sync functions!");
            }
            SyncHandler t = (SyncHandler)supplier.get();
            boolean l = this.locked;
            this.locked = false;
            this.putSyncValue(name, id, t);
            this.locked = l;
            return (T)t;
        }
        if (clazz.isAssignableFrom(syncHandler.getClass())) {
            return (T)((SyncHandler)clazz.cast(syncHandler));
        }
        throw new IllegalStateException("SyncHandler for key " + PanelSyncManager.makeSyncKey(name, id) + " is of type " + String.valueOf(syncHandler.getClass()) + ", but type " + String.valueOf(clazz) + " was expected!");
    }

    @Override
    public SlotGroup getSlotGroup(String name) {
        return this.slotGroups.get(name);
    }

    public Collection<SlotGroup> getSlotGroups() {
        return this.slotGroups.values();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    @Nullable
    public SyncHandler getSyncHandler(String mapKey) {
        return this.getSyncHandlerFromMapKey(mapKey);
    }

    @Nullable
    public SyncHandler getSyncHandlerFromMapKey(String mapKey) {
        return this.syncHandlers.get(mapKey);
    }

    @Override
    @Nullable
    public SyncHandler findSyncHandlerNullable(String name, int id) {
        return this.syncHandlers.get(PanelSyncManager.makeSyncKey(name, id));
    }

    public Player getPlayer() {
        return this.getModularSyncManager().getPlayer();
    }

    public ISyncRegistrar<?> getHyperVisor() {
        return this.modularSyncManager.getMainPSM();
    }

    public ModularContainerMenu getContainer() {
        return this.getModularSyncManager().getMenu();
    }

    void allowTemporarySyncHandlerRegistration(boolean allow) {
        this.allowSyncHandlerRegistration = allow;
    }

    public static String makeSyncKey(String name, int id) {
        return name + ":" + id;
    }

    @Generated
    public ModularSyncManager getModularSyncManager() {
        return this.modularSyncManager;
    }

    @Generated
    public String getPanelName() {
        return this.panelName;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public boolean isClient() {
        return this.client;
    }

    public static interface SlotFunction {
        @NotNull
        public ModularSlot apply(@NotNull PlayerMainInvWrapper var1, int var2);
    }
}

