/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.PlayerSlotType;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ItemSlotSyncHandler
extends SyncHandler {
    public static final int SYNC_ITEM = 0;
    public static final int SYNC_ENABLED = 1;
    private final ModularSlot slot;
    @Nullable
    private final PlayerSlotType playerSlotType;
    private ItemStack lastStoredItem;
    private boolean registered = false;

    public ItemSlotSyncHandler(ModularSlot slot) {
        this.slot = slot;
        this.playerSlotType = PlayerSlotType.getPlayerSlotType((Slot)slot);
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        if (!this.registered) {
            this.slot.initialize(this, this.isPhantom());
            this.getSyncManager().getContainer().registerSlot(this.getSyncManager().getPanelName(), this.slot);
            this.registered = true;
        }
        this.lastStoredItem = this.getSlot().m_7993_().m_41777_();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.slot.dispose();
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        ItemStack itemStack = this.getSlot().m_7993_();
        if (itemStack.m_41619_() && this.lastStoredItem.m_41619_()) {
            return;
        }
        boolean onlyAmountChanged = false;
        if (init || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastStoredItem, (ItemStack)itemStack) || (onlyAmountChanged = itemStack.m_41613_() != this.lastStoredItem.m_41613_())) {
            this.onSlotUpdate(itemStack, onlyAmountChanged, false, init);
            if (onlyAmountChanged) {
                this.lastStoredItem.m_41764_(itemStack.m_41613_());
            } else {
                this.lastStoredItem = itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack.m_41777_();
            }
            boolean finalOnlyAmountChanged = onlyAmountChanged;
            boolean forceSync = false;
            this.syncToClient(0, buffer -> {
                buffer.writeBoolean(finalOnlyAmountChanged);
                buffer.m_130055_(itemStack);
                buffer.writeBoolean(init);
                buffer.writeBoolean(false);
            });
        }
    }

    @Override
    public void readOnClient(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            boolean onlyAmountChanged = buf.readBoolean();
            this.lastStoredItem = buf.m_130267_();
            this.onSlotUpdate(this.lastStoredItem, onlyAmountChanged, true, buf.readBoolean());
            if (buf.readBoolean()) {
                this.slot.m_5852_(this.lastStoredItem);
            }
        } else if (id == 1) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    @Override
    public void readOnServer(int id, FriendlyByteBuf buf) {
        if (id == 1) {
            this.setEnabled(buf.readBoolean(), false);
        }
    }

    protected void onSlotUpdate(ItemStack stack, boolean onlyAmountChanged, boolean client, boolean init) {
        this.getSlot().onSlotChangedReal(stack, onlyAmountChanged, client, init);
    }

    public void setEnabled(boolean enabled, boolean sync) {
        this.slot.setEnabled(enabled);
        if (sync) {
            this.sync(1, buffer -> buffer.writeBoolean(enabled));
        }
    }

    public void forceSyncItem() {
        boolean onlyAmountChanged = false;
        ItemStack stack = this.slot.m_7993_();
        boolean init = false;
        boolean forceSync = true;
        this.onSlotUpdate(stack, onlyAmountChanged, this.getSyncManager().isClient(), init);
        this.lastStoredItem = stack.m_41619_() ? ItemStack.f_41583_ : stack;
        this.syncToClient(0, buffer -> {
            buffer.writeBoolean(onlyAmountChanged);
            buffer.m_130055_(stack);
            buffer.writeBoolean(init);
            buffer.writeBoolean(forceSync);
        });
    }

    public boolean isItemValid(ItemStack itemStack) {
        return this.getSlot().m_5857_(itemStack);
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isPlayerSlot() {
        return this.playerSlotType != null;
    }

    @Nullable
    public String getSlotGroup() {
        return this.slot.getSlotGroupName();
    }

    @Generated
    public ModularSlot getSlot() {
        return this.slot;
    }

    @Nullable
    @Generated
    public PlayerSlotType getPlayerSlotType() {
        return this.playerSlotType;
    }
}

