/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.utils.EqualityTest;
import brachy.modularui.utils.ICopy;
import brachy.modularui.utils.ObjectList;
import brachy.modularui.utils.serialization.network.IByteBufDeserializer;
import brachy.modularui.utils.serialization.network.IByteBufSerializer;
import brachy.modularui.value.sync.GenericCollectionSyncHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericListSyncHandler<T>
extends GenericCollectionSyncHandler<T, List<T>> {
    private final ObjectList<T> cache = ObjectList.create();

    public GenericListSyncHandler(@NotNull Supplier<List<T>> getter, @Nullable Consumer<List<T>> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable EqualityTest<T> equals, @Nullable ICopy<T> copy) {
        super(getter, setter, deserializer, serializer, equals, copy);
    }

    @Override
    protected void setCache(List<T> value) {
        this.cache.clear();
        for (T item : value) {
            this.cache.add(this.copyValue(item));
        }
    }

    @Override
    protected boolean didValuesChange(List<T> newValues) {
        if (this.cache.size() != newValues.size()) {
            return true;
        }
        for (int i = 0; i < this.cache.size(); ++i) {
            if (this.areValuesEqual(this.cache.get(i), newValues.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> getValue() {
        return Collections.unmodifiableList(this.cache);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.cache.clear();
        for (int i = 0; i < buffer.m_130242_(); ++i) {
            this.cache.add(this.deserializeValue(buffer));
        }
        this.onSetCache(this.getValue(), true, false);
    }

    @Override
    public Class<List<T>> getValueType() {
        return List.class;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T>
    extends GenericCollectionSyncHandler.Builder<T, List<T>, Builder<T>> {
        public Builder<T> getterArray(Supplier<T[]> getter) {
            this.getter(() -> Arrays.asList((Object[])getter.get()));
            return this;
        }

        public Builder<T> setterArray(Consumer<T[]> setter, IntFunction<T[]> arrayFactory) {
            this.setter(c -> setter.accept(c.toArray((Object[])arrayFactory.apply(c.size()))));
            return this;
        }

        @Override
        public Builder<T> equals(EqualityTest<T> equals) {
            super.equals(equals);
            return this;
        }

        public GenericListSyncHandler<T> build() {
            if (this.getter == null) {
                throw new NullPointerException("Getter in GenericListSyncHandler must not be null");
            }
            if (this.deserializer == null) {
                throw new NullPointerException("Deserializer in GenericListSyncHandler must not be null");
            }
            if (this.serializer == null) {
                throw new NullPointerException("Serializer in GenericListSyncHandler must not be null");
            }
            return new GenericListSyncHandler(this.getter, this.setter, this.deserializer, this.serializer, this.equals, this.copy);
        }
    }
}

