/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.utils.EqualityTest;
import brachy.modularui.utils.ICopy;
import brachy.modularui.utils.serialization.network.IByteBufAdapter;
import brachy.modularui.utils.serialization.network.IByteBufDeserializer;
import brachy.modularui.utils.serialization.network.IByteBufSerializer;
import brachy.modularui.value.sync.ValueSyncHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericCollectionSyncHandler<T, C extends Collection<T>>
extends ValueSyncHandler<C> {
    private final Supplier<C> getter;
    private final Consumer<C> setter;
    private final IByteBufDeserializer<T> deserializer;
    private final IByteBufSerializer<T> serializer;
    private final EqualityTest<T> equals;
    private final ICopy<T> copy;

    protected GenericCollectionSyncHandler(@NotNull Supplier<C> getter, @Nullable Consumer<C> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable EqualityTest<T> equals, @Nullable ICopy<T> copy) {
        this.getter = getter;
        this.setter = setter;
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.equals = equals != null ? EqualityTest.wrapNullSafe(equals) : Objects::equals;
        this.copy = copy != null ? copy : ICopy.ofSerializer(serializer, deserializer);
    }

    @Override
    public void setValue(C value, boolean setSource, boolean sync) {
        this.setCache(value);
        this.onSetCache(value, setSource, sync);
    }

    protected abstract void setCache(C var1);

    protected void onSetCache(C value, boolean setSource, boolean sync) {
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        Collection c = (Collection)this.getter.get();
        if (isFirstSync || this.didValuesChange(c)) {
            this.setValue((C)c, false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        this.setValue((C)((Collection)this.getter.get()), false, true);
    }

    protected abstract boolean didValuesChange(C var1);

    @Override
    public void write(FriendlyByteBuf buffer) {
        Object c = this.getValue();
        buffer.m_130130_(c.size());
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            this.serializer.serialize(buffer, t);
        }
    }

    @Override
    public abstract C getValue();

    public boolean areValuesEqual(T a, T b) {
        return this.equals.areEqual(a, b);
    }

    protected T deserializeValue(FriendlyByteBuf buffer) {
        return this.deserializer.deserialize(buffer);
    }

    protected T copyValue(T value) {
        return this.copy.createDeepCopy(value);
    }

    public static class Builder<T, C extends Collection<T>, B extends Builder<T, C, B>> {
        protected Supplier<C> getter;
        protected Consumer<C> setter;
        protected IByteBufDeserializer<T> deserializer;
        protected IByteBufSerializer<T> serializer;
        protected EqualityTest<T> equals;
        protected ICopy<T> copy;

        public B getter(Supplier<C> getter) {
            this.getter = getter;
            return this.getSelf();
        }

        public B setter(Consumer<C> setter) {
            this.setter = setter;
            return this.getSelf();
        }

        public B deserializer(IByteBufDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this.getSelf();
        }

        public B serializer(IByteBufSerializer<T> serializer) {
            this.serializer = serializer;
            return this.getSelf();
        }

        protected B equals(EqualityTest<T> equals) {
            this.equals = equals;
            return this.getSelf();
        }

        public B adapter(IByteBufAdapter<T> adapter) {
            return ((Builder)((Builder)this.deserializer(adapter)).serializer(adapter)).equals(adapter);
        }

        public B copy(ICopy<T> copy) {
            this.copy = copy;
            return this.getSelf();
        }

        public B immutableCopy() {
            return this.copy(ICopy.immutable());
        }

        protected B getSelf() {
            return (B)this;
        }
    }
}

