/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.utils.FluidTankHandler;
import brachy.modularui.utils.MouseData;
import brachy.modularui.value.sync.ValueSyncHandler;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlotSyncHandler
extends ValueSyncHandler<FluidStack> {
    public static final int SYNC_CLICK = 1;
    public static final int SYNC_SCROLL = 2;
    public static final int SYNC_CONTROLS_AMOUNT = 3;
    @NotNull
    private FluidStack cache = FluidStack.EMPTY;
    private final IFluidTank fluidTank;
    private final IFluidHandler fluidHandler;
    private boolean canFillSlot = true;
    private boolean canDrainSlot = true;
    private boolean phantom = false;
    private boolean controlsAmount = true;
    @Nullable
    private FluidStack lastStoredPhantomFluid;

    public FluidSlotSyncHandler(IFluidTank fluidTank) {
        this.fluidTank = fluidTank;
        this.fluidHandler = FluidTankHandler.getTankFluidHandler(fluidTank);
    }

    @Override
    @Nullable
    public FluidStack getValue() {
        return this.cache;
    }

    @Override
    public void setValue(@NotNull FluidStack value, boolean setSource, boolean sync) {
        this.cache = value.copy();
        if (setSource) {
            this.fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            if (!value.isEmpty()) {
                this.fluidTank.fill(value.copy(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    public boolean needsSync() {
        FluidStack current = this.fluidTank.getFluid();
        if (current == this.cache) {
            return false;
        }
        if (current.isEmpty() && this.cache.isEmpty()) {
            return true;
        }
        return !current.isFluidStackIdentical(this.cache);
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.needsSync()) {
            this.setValue(this.fluidTank.getFluid(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    @Override
    public void notifyUpdate() {
        this.setValue(this.fluidTank.getFluid(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.cache.writeToPacket(buffer);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setValue(FluidStack.readFromPacket((FriendlyByteBuf)buffer), true, false);
    }

    @Override
    public void readOnClient(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.read(buf);
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            if (this.phantom) {
                this.read(buf);
            }
        } else if (id == 1) {
            if (this.phantom) {
                this.tryClickPhantom(MouseData.readPacket(buf));
            } else {
                this.tryClickContainer(MouseData.readPacket(buf));
            }
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(MouseData.readPacket(buf));
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    private void tryClickContainer(MouseData mouseData) {
        int maxAttempts;
        Player player = this.getSyncManager().getPlayer();
        ItemStack currentStack = player.f_36096_.m_142621_();
        if (!currentStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).isPresent()) {
            return;
        }
        int n = maxAttempts = mouseData.shift() ? currentStack.m_41613_() : 1;
        if (mouseData.mouseButton() == 1 && this.canFillSlot) {
            boolean performedTransfer = false;
            for (int i = 0; i < maxAttempts; ++i) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
                ItemStack remainingStack = result.getResult();
                if (!result.isSuccess() || currentStack.m_41613_() > 1 && !remainingStack.m_41619_() && !player.m_150109_().m_36054_(remainingStack)) {
                    player.m_36176_(remainingStack, true);
                    break;
                }
                remainingStack = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true).result;
                if (currentStack.m_41613_() == 1) {
                    currentStack = remainingStack;
                } else {
                    currentStack.m_41774_(1);
                }
                performedTransfer = true;
                if (currentStack.m_41619_()) break;
            }
            FluidStack fluid = this.fluidTank.getFluid();
            if (performedTransfer && !fluid.isEmpty()) {
                this.playSound(fluid, SoundActions.BUCKET_EMPTY);
                this.getSyncManager().setCursorItem(currentStack);
            }
            return;
        }
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (mouseData.mouseButton() == 0 && this.canDrainSlot && !currentFluid.isEmpty()) {
            boolean performedTransfer = false;
            for (int i = 0; i < maxAttempts; ++i) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
                ItemStack remainingStack = result.getResult();
                if (!result.isSuccess() || currentStack.m_41613_() > 1 && !remainingStack.m_41619_() && !player.m_150109_().m_36054_(remainingStack)) break;
                remainingStack = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true).result;
                if (currentStack.m_41613_() == 1) {
                    currentStack = remainingStack;
                } else {
                    currentStack.m_41774_(1);
                }
                performedTransfer = true;
                if (currentStack.m_41619_()) break;
            }
            if (performedTransfer) {
                this.playSound(currentFluid, SoundActions.BUCKET_FILL);
                this.getSyncManager().setCursorItem(currentStack);
            }
        }
    }

    public void tryClickPhantom(MouseData mouseData) {
        Player player = this.getSyncManager().getPlayer();
        ItemStack currentStack = player.f_36096_.m_142621_();
        FluidStack currentFluid = this.fluidTank.getFluid();
        IFluidHandlerItem fluidHandlerItem = currentStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).resolve().orElse(null);
        if (mouseData.mouseButton() == 0) {
            if (currentStack.m_41619_() || fluidHandlerItem == null) {
                if (this.canDrainSlot) {
                    this.fluidTank.drain(mouseData.shift() ? Integer.MAX_VALUE : 1000, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                FluidStack cellFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if ((this.controlsAmount || currentFluid.isEmpty()) && !cellFluid.isEmpty()) {
                    if (this.canFillSlot) {
                        if (!this.controlsAmount) {
                            cellFluid.setAmount(1);
                        }
                        if (this.fluidTank.fill(cellFluid, IFluidHandler.FluidAction.EXECUTE) > 0) {
                            this.lastStoredPhantomFluid = cellFluid.copy();
                        }
                    }
                } else if (this.canDrainSlot) {
                    this.fluidTank.drain(mouseData.shift() ? Integer.MAX_VALUE : 1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else if (mouseData.mouseButton() == 1) {
            if (this.canFillSlot) {
                if (!currentFluid.isEmpty()) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.setAmount(1000);
                        this.fluidTank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    FluidStack toFill = this.lastStoredPhantomFluid.copy();
                    toFill.setAmount(this.controlsAmount ? 1000 : 1);
                    this.fluidTank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else if (mouseData.mouseButton() == 2 && !currentFluid.isEmpty() && this.canDrainSlot) {
            this.fluidTank.drain(mouseData.shift() ? Integer.MAX_VALUE : 1000, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void tryScrollPhantom(MouseData mouseData) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        int amount = mouseData.mouseButton();
        if (mouseData.shift()) {
            amount *= 10;
        }
        if (mouseData.ctrl()) {
            amount *= 100;
        }
        if (mouseData.alt()) {
            amount *= 1000;
        }
        if (currentFluid.isEmpty()) {
            if (amount > 0 && this.lastStoredPhantomFluid != null) {
                FluidStack toFill = this.lastStoredPhantomFluid.copy();
                toFill.setAmount(this.controlsAmount ? amount : 1);
                this.fluidTank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
            }
            return;
        }
        if (amount > 0 && this.controlsAmount) {
            FluidStack toFill = currentFluid.copy();
            toFill.setAmount(amount);
            this.fluidTank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
        } else if (amount < 0) {
            this.fluidTank.drain(-amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void playSound(FluidStack fluid, SoundAction action) {
        Player player = this.getSyncManager().getPlayer();
        SoundEvent sound = fluid.getFluid().getFluidType().getSound(fluid, action);
        if (sound == null) {
            return;
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public FluidSlotSyncHandler controlsAmount(boolean controlsAmount) {
        this.controlsAmount = controlsAmount;
        if (this.isValid()) {
            this.sync(3, buffer -> buffer.writeBoolean(controlsAmount));
        }
        return this;
    }

    @Generated
    public IFluidTank fluidTank() {
        return this.fluidTank;
    }

    @Generated
    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    @Generated
    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    @Generated
    public boolean phantom() {
        return this.phantom;
    }

    @NotNull
    @Generated
    public FluidSlotSyncHandler canFillSlot(boolean canFillSlot) {
        this.canFillSlot = canFillSlot;
        return this;
    }

    @NotNull
    @Generated
    public FluidSlotSyncHandler canDrainSlot(boolean canDrainSlot) {
        this.canDrainSlot = canDrainSlot;
        return this;
    }

    @NotNull
    @Generated
    public FluidSlotSyncHandler phantom(boolean phantom) {
        this.phantom = phantom;
        return this;
    }

    @Generated
    public boolean controlsAmount() {
        return this.controlsAmount;
    }
}

