/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.api.value.sync.IDoubleSyncValue;
import brachy.modularui.api.value.sync.IFloatSyncValue;
import brachy.modularui.api.value.sync.IStringSyncValue;
import brachy.modularui.utils.FloatConsumer;
import brachy.modularui.utils.FloatSupplier;
import brachy.modularui.value.sync.ValueSyncHandler;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatSyncValue
extends ValueSyncHandler<Float>
implements IFloatSyncValue<Float>,
IDoubleSyncValue<Float>,
IStringSyncValue<Float> {
    private final FloatSupplier getter;
    private final FloatConsumer setter;
    private float cache;

    public FloatSyncValue(@NotNull FloatSupplier getter, @Nullable FloatConsumer setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.cache = getter.getAsFloat();
    }

    public FloatSyncValue(@NotNull FloatSupplier getter) {
        this(getter, (FloatConsumer)null);
    }

    @Contract(value="null, null -> fail")
    public FloatSyncValue(@Nullable FloatSupplier clientGetter, @Nullable FloatSupplier serverGetter) {
        this(clientGetter, null, serverGetter, null);
    }

    @Contract(value="null, _, null, _ -> fail")
    public FloatSyncValue(@Nullable FloatSupplier clientGetter, @Nullable FloatConsumer clientSetter, @Nullable FloatSupplier serverGetter, @Nullable FloatConsumer serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (ModularUI.isClientThread()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.getAsFloat();
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.cache);
    }

    @Override
    public void setValue(@NotNull Float value, boolean setSource, boolean sync) {
        this.setFloatValue(value.floatValue(), setSource, sync);
    }

    @Override
    public float getFloatValue() {
        return this.cache;
    }

    @Override
    public void setFloatValue(float value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.getter.getAsFloat() != this.cache) {
            this.setFloatValue(this.getter.getAsFloat(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        this.setFloatValue(this.getter.getAsFloat(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getFloatValue());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setFloatValue(buffer.readFloat(), true, false);
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setFloatValue(Float.parseFloat(value), setSource, sync);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.cache);
    }

    @Override
    public double getDoubleValue() {
        return this.getFloatValue();
    }

    @Override
    public void setDoubleValue(double value, boolean setSource, boolean sync) {
        this.setFloatValue((float)value, setSource, sync);
    }

    @Override
    public Class<Float> getValueType() {
        return Float.class;
    }
}

