/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.api.value.sync.IDoubleSyncValue;
import brachy.modularui.api.value.sync.IFloatSyncValue;
import brachy.modularui.api.value.sync.IStringSyncValue;
import brachy.modularui.value.sync.ValueSyncHandler;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleSyncValue
extends ValueSyncHandler<Double>
implements IDoubleSyncValue<Double>,
IFloatSyncValue<Double>,
IStringSyncValue<Double> {
    private final DoubleSupplier getter;
    private final DoubleConsumer setter;
    private double cache;

    public DoubleSyncValue(@NotNull DoubleSupplier getter, @Nullable DoubleConsumer setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.cache = getter.getAsDouble();
    }

    public DoubleSyncValue(@NotNull DoubleSupplier getter) {
        this(getter, (DoubleConsumer)null);
    }

    @Contract(value="null, null -> fail")
    public DoubleSyncValue(@Nullable DoubleSupplier clientGetter, @Nullable DoubleSupplier serverGetter) {
        this(clientGetter, null, serverGetter, null);
    }

    @Contract(value="null, _, null, _ -> fail")
    public DoubleSyncValue(@Nullable DoubleSupplier clientGetter, @Nullable DoubleConsumer clientSetter, @Nullable DoubleSupplier serverGetter, @Nullable DoubleConsumer serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (ModularUI.isClientThread()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.getAsDouble();
    }

    @Override
    public Double getValue() {
        return this.cache;
    }

    @Override
    public double getDoubleValue() {
        return this.cache;
    }

    @Override
    public void setValue(@NotNull Double value, boolean setSource, boolean sync) {
        this.setDoubleValue(value, setSource, sync);
    }

    @Override
    public void setDoubleValue(double value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.getter.getAsDouble() != this.cache) {
            this.setDoubleValue(this.getter.getAsDouble(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        this.setDoubleValue(this.getter.getAsDouble(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.getDoubleValue());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setDoubleValue(buffer.readDouble(), true, false);
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setDoubleValue(Double.parseDouble(value), setSource, sync);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.cache);
    }

    @Override
    public float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    @Override
    public void setFloatValue(float value, boolean setSource, boolean sync) {
        this.setDoubleValue(value, setSource, sync);
    }

    @Override
    public Class<Double> getValueType() {
        return Double.class;
    }
}

