/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.api.value.sync.IBoolSyncValue;
import brachy.modularui.api.value.sync.IStringSyncValue;
import brachy.modularui.value.sync.ValueSyncHandler;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanSyncValue
extends ValueSyncHandler<Boolean>
implements IBoolSyncValue<Boolean>,
IStringSyncValue<Boolean> {
    private final BooleanSupplier getter;
    private final BooleanConsumer setter;
    private boolean cache;

    public BooleanSyncValue(@NotNull BooleanSupplier getter, @Nullable BooleanConsumer setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.cache = getter.getAsBoolean();
    }

    public BooleanSyncValue(@NotNull BooleanSupplier getter) {
        this(getter, (BooleanConsumer)null);
    }

    @Contract(value="null, null -> fail")
    public BooleanSyncValue(@Nullable BooleanSupplier clientGetter, @Nullable BooleanSupplier serverGetter) {
        this(clientGetter, null, serverGetter, null);
    }

    @Contract(value="null, _, null, _ -> fail")
    public BooleanSyncValue(@Nullable BooleanSupplier clientGetter, @Nullable BooleanConsumer clientSetter, @Nullable BooleanSupplier serverGetter, @Nullable BooleanConsumer serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (ModularUI.isClientThread()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.getAsBoolean();
    }

    @Override
    public Boolean getValue() {
        return this.cache;
    }

    @Override
    public boolean getBoolValue() {
        return this.cache;
    }

    @Override
    public void setValue(@NotNull Boolean value, boolean setSource, boolean sync) {
        this.setBoolValue(value, setSource, sync);
    }

    @Override
    public void setBoolValue(boolean value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.getter.getAsBoolean() != this.cache) {
            this.setBoolValue(this.getter.getAsBoolean(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        this.setBoolValue(this.getter.getAsBoolean(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getBoolValue());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setBoolValue(buffer.readBoolean(), true, false);
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setBoolValue(Boolean.getBoolean(value), setSource, sync);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.cache);
    }

    @Override
    public Class<Boolean> getValueType() {
        return Boolean.class;
    }
}

