/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.value.sync.ValueSyncHandler;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGenericSyncValue<T>
extends ValueSyncHandler<T> {
    private final Class<T> type;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private T cache;

    protected AbstractGenericSyncValue(Class<T> type, Supplier<T> getter, Consumer<T> setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.cache = getter.get();
        if (type == null && this.cache != null) {
            type = this.cache.getClass();
        }
        this.type = type;
    }

    @Contract(value="_, null, _, null, _ -> fail")
    protected AbstractGenericSyncValue(Class<T> type, @Nullable Supplier<T> clientGetter, @Nullable Consumer<T> clientSetter, @Nullable Supplier<T> serverGetter, @Nullable Consumer<T> serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (ModularUI.isClientThread()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.get();
        if (type == null && this.cache != null) {
            type = this.cache.getClass();
        }
        this.type = type;
    }

    protected abstract T createDeepCopyOf(T var1);

    protected abstract boolean areEqual(T var1, T var2);

    protected abstract void serialize(FriendlyByteBuf var1, T var2);

    protected abstract T deserialize(FriendlyByteBuf var1);

    @Override
    public T getValue() {
        return this.cache;
    }

    @Override
    public void setValue(T value, boolean setSource, boolean sync) {
        this.cache = this.createDeepCopyOf(value);
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (this.getter == null) {
            return false;
        }
        T t = this.getter.get();
        if (isFirstSync || !this.areEqual(this.cache, t)) {
            this.setValue(t, false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        if (this.getter == null) {
            throw new NullPointerException("Can't notify sync handler with null getter.");
        }
        this.setValue(this.getter.get(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.serialize(buffer, this.cache);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setValue(this.deserialize(buffer), true, false);
    }

    @Override
    public Class<T> getValueType() {
        return this.getType();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    @Nullable
    public Class<? extends T> getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.cache != null) {
            return this.cache.getClass();
        }
        T t = this.getter.get();
        if (t != null) {
            return t.getClass();
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public boolean isOfType(Class<?> expectedType) {
        return this.isValueOfType(expectedType);
    }

    @Override
    public boolean isValueOfType(Class<?> expectedType) {
        Class<T> type = this.getValueType();
        if (type == null) {
            throw new IllegalStateException("Could not infer type of GenericSyncValue since value is null!");
        }
        return expectedType.isAssignableFrom(type);
    }

    public <V> AbstractGenericSyncValue<V> cast() {
        return this;
    }
}

