/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value;

import brachy.modularui.api.value.IIntValue;
import brachy.modularui.api.value.ILongValue;
import brachy.modularui.api.value.IStringValue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;

public class LongValue
implements ILongValue<Long>,
IIntValue<Long>,
IStringValue<Long> {
    private long value;

    public static Dynamic wrap(ILongValue<?> val) {
        return new Dynamic(val::getLongValue, val::setLongValue);
    }

    public static Dynamic wrapAtomic(AtomicLong val) {
        return new Dynamic(val::get, val::set);
    }

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.getLongValue();
    }

    @Override
    public void setValue(Long value) {
        this.setLongValue(value);
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long val) {
        this.value = val;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public void setStringValue(String val) {
        this.setLongValue(Long.parseLong(val));
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public void setIntValue(int val) {
        this.setLongValue(val);
    }

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    public static class Dynamic
    implements ILongValue<Long>,
    IIntValue<Long>,
    IStringValue<Long> {
        private final LongSupplier getter;
        private final LongConsumer setter;

        public Dynamic(LongSupplier getter, LongConsumer setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public long getLongValue() {
            return this.getter.getAsLong();
        }

        @Override
        public void setLongValue(long val) {
            this.setter.accept(val);
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.getLongValue());
        }

        @Override
        public void setStringValue(String val) {
            this.setLongValue(Long.parseLong(val));
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        @Override
        public void setValue(Long value) {
            this.setLongValue(value);
        }

        @Override
        public int getIntValue() {
            return (int)this.getLongValue();
        }

        @Override
        public void setIntValue(int val) {
            this.setLongValue(val);
        }

        @Override
        public Class<Long> getValueType() {
            return Long.class;
        }
    }
}

