/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils.serialization.network;

import brachy.modularui.utils.EqualityTest;
import brachy.modularui.utils.NetworkUtils;
import brachy.modularui.utils.serialization.network.IByteBufAdapter;
import brachy.modularui.utils.serialization.network.IByteBufDeserializer;
import brachy.modularui.utils.serialization.network.IByteBufMemberSerializer;
import brachy.modularui.utils.serialization.network.IByteBufSerializer;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteBufAdapters {
    public static final IByteBufAdapter<ItemStack> ITEM_STACK = ByteBufAdapters.makeAdapter(FriendlyByteBuf::m_130267_, FriendlyByteBuf::m_130055_, ItemStack::m_41728_);
    public static final IByteBufAdapter<FluidStack> FLUID_STACK = ByteBufAdapters.makeMemberAdapter(FluidStack::readFromPacket, FluidStack::writeToPacket, FluidStack::isFluidStackIdentical);
    public static final IByteBufAdapter<CompoundTag> NBT = ByteBufAdapters.makeAdapter(FriendlyByteBuf::m_130260_, FriendlyByteBuf::m_130079_, null);
    public static final IByteBufAdapter<String> STRING = ByteBufAdapters.makeAdapter(NetworkUtils::readStringSafe, NetworkUtils::writeStringSafe, null);
    public static final IByteBufAdapter<ByteBuf> BYTE_BUF = ByteBufAdapters.makeAdapter(NetworkUtils::readByteBuf, NetworkUtils::writeByteBuf, null);
    public static final IByteBufAdapter<FriendlyByteBuf> FRIENDLY_BYTE_BUF = ByteBufAdapters.makeAdapter(NetworkUtils::readFriendlyByteBuf, NetworkUtils::writeByteBuf, null);
    public static final IByteBufAdapter<byte[]> BYTE_ARR = new IByteBufAdapter<byte[]>(){

        @Override
        public byte[] deserialize(FriendlyByteBuf buffer) {
            return buffer.m_130052_();
        }

        @Override
        public void serialize(FriendlyByteBuf buffer, byte[] u) {
            buffer.m_130087_(u);
        }

        @Override
        public boolean areEqual(byte @NotNull [] t1, byte @NotNull [] t2) {
            if (t1.length != t2.length) {
                return false;
            }
            for (int i = 0; i < t1.length; ++i) {
                if (t1[i] == t2[i]) continue;
                return false;
            }
            return true;
        }
    };
    public static final IByteBufAdapter<long[]> LONG_ARR = new IByteBufAdapter<long[]>(){

        @Override
        public long[] deserialize(FriendlyByteBuf buffer) {
            return buffer.m_178381_();
        }

        @Override
        public void serialize(FriendlyByteBuf buffer, long[] u) {
            buffer.m_130091_(u);
        }

        @Override
        public boolean areEqual(long @NotNull [] t1, long @NotNull [] t2) {
            if (t1.length != t2.length) {
                return false;
            }
            for (int i = 0; i < t1.length; ++i) {
                if (t1[i] == t2[i]) continue;
                return false;
            }
            return true;
        }
    };
    public static final IByteBufAdapter<BigInteger> BIG_INT = new IByteBufAdapter<BigInteger>(){

        @Override
        public BigInteger deserialize(FriendlyByteBuf buffer) {
            return new BigInteger(buffer.m_130052_());
        }

        @Override
        public void serialize(FriendlyByteBuf buffer, BigInteger u) {
            buffer.writeBytes(u.toByteArray());
        }

        @Override
        public boolean areEqual(@NotNull BigInteger t1, @NotNull BigInteger t2) {
            return t1.equals(t2);
        }
    };
    public static final IByteBufAdapter<BigDecimal> BIG_DECIMAL = new IByteBufAdapter<BigDecimal>(){

        @Override
        public BigDecimal deserialize(FriendlyByteBuf buffer) {
            return new BigDecimal(BIG_INT.deserialize(buffer), buffer.m_130242_());
        }

        @Override
        public void serialize(FriendlyByteBuf buffer, BigDecimal u) {
            BIG_INT.serialize(buffer, u.unscaledValue());
            buffer.m_130130_(u.scale());
        }

        @Override
        public boolean areEqual(@NotNull BigDecimal t1, @NotNull BigDecimal t2) {
            return t1.equals(t2);
        }
    };

    public static <T> IByteBufAdapter<T> makeAdapter(final @NotNull IByteBufDeserializer<T> deserializer, final @NotNull IByteBufSerializer<T> serializer, final @Nullable EqualityTest<T> tester) {
        return new IByteBufAdapter<T>(){

            @Override
            public T deserialize(FriendlyByteBuf buffer) {
                return deserializer.deserialize(buffer);
            }

            @Override
            public void serialize(FriendlyByteBuf buffer, T u) {
                serializer.serialize(buffer, u);
            }

            @Override
            public boolean areEqual(@NotNull T t1, @NotNull T t2) {
                return tester != null ? tester.areEqual(t1, t2) : Objects.equals(t1, t2);
            }
        };
    }

    public static <T> IByteBufAdapter<T> makeMemberAdapter(@NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufMemberSerializer<T> memberSerializer, @Nullable EqualityTest<T> comparator) {
        return ByteBufAdapters.makeAdapter(deserializer, memberSerializer.asBasic(), comparator);
    }
}

