/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils.serialization.json;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.DrawableSerialization;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.Color;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(IDrawable.class, (Object)new DrawableSerialization()).registerTypeAdapter(Alignment.class, (Object)new Alignment.Json()).create();

    public static JsonElement serialize(Object object) {
        return GSON.toJsonTree(object);
    }

    public static <T> T deserialize(JsonElement json, Class<T> clazz) {
        return (T)GSON.fromJson(json, clazz);
    }

    public static <T> T deserialize(JsonObject json, Class<T> clazz, T defaultValue, String ... keys) {
        JsonElement element = JsonHelper.getJsonElement(json, keys);
        if (element != null) {
            T t = JsonHelper.deserialize(element, clazz);
            return t == null ? defaultValue : t;
        }
        return defaultValue;
    }

    public static <T> T deserializeWithFallback(JsonObject json, JsonObject fallback, Class<T> clazz, T defaultValue, String ... keys) {
        T t = JsonHelper.deserialize(json, clazz, null, keys);
        return t != null ? t : (T)JsonHelper.deserialize(fallback, clazz, defaultValue, keys);
    }

    public static float getFloat(JsonObject json, float defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsFloat();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static int getInt(JsonObject json, int defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsInt();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static int getIntWithFallback(JsonObject json, JsonObject fallback, int defaultValue, String ... keys) {
        Integer i = JsonHelper.getBoxedInt(json, null, keys);
        return i != null ? i : JsonHelper.getInt(fallback, defaultValue, keys);
    }

    public static boolean getBoolean(JsonObject json, boolean defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsBoolean();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static boolean getBoolWithFallback(JsonObject json, JsonObject fallback, boolean defaultValue, String ... keys) {
        Boolean i = JsonHelper.getBoxedBool(json, null, keys);
        return i != null ? i : JsonHelper.getBoolean(fallback, defaultValue, keys);
    }

    public static String getString(JsonObject json, String defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            return jsonElement.getAsString();
        }
        return defaultValue;
    }

    public static <T> T getObject(JsonObject json, T defaultValue, Function<JsonObject, T> factory, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonObject()) {
                return factory.apply(jsonElement.getAsJsonObject());
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static <T> T getElement(JsonObject json, T defaultValue, Function<JsonElement, T> factory, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            return factory.apply(jsonElement);
        }
        return defaultValue;
    }

    @Nullable
    public static Integer getBoxedInt(JsonObject json, Integer defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsInt();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    @Nullable
    public static Boolean getBoxedBool(JsonObject json, Boolean defaultValue, String ... keys) {
        if (json == null) {
            return defaultValue;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            JsonElement jsonElement = json.get(key);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsBoolean();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static int getColor(JsonObject json, int defaultValue, String ... keys) {
        JsonElement element = JsonHelper.getJsonElement(json, keys);
        if (element != null) {
            return Color.ofJson(element);
        }
        return defaultValue;
    }

    public static int getColorWithFallback(JsonObject json, JsonObject fallback, int defaultValue, String ... keys) {
        JsonElement element = JsonHelper.getJsonElement(json, keys);
        if (element != null) {
            return Color.ofJson(element);
        }
        return JsonHelper.getColor(fallback, defaultValue, keys);
    }

    @Nullable
    public static JsonElement getJsonElement(JsonObject json, String ... keys) {
        if (json == null) {
            return null;
        }
        for (String key : keys) {
            if (!json.has(key)) continue;
            return json.get(key);
        }
        return null;
    }

    public static JsonElement parse(InputStream inputStream) {
        return JsonParser.parseReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static JsonObject merge(JsonObject base, JsonObject other) {
        for (Map.Entry entry : other.entrySet()) {
            base.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return base;
    }

    public static JsonObject makeJson(Consumer<JsonObject> writer) {
        JsonObject json = new JsonObject();
        writer.accept(json);
        return json;
    }
}

