/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils.fakelevel;

import brachy.modularui.ModularUI;
import brachy.modularui.schema.ISchema;
import brachy.modularui.utils.BlockPosUtil;
import brachy.modularui.utils.fakelevel.DummyChunkSource;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SchemaLevel
extends Level
implements ISchema {
    private static final ResourceKey<Level> LEVEL_ID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ModularUI.id("fake_level"));
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());
    private final LongSet filledBlocks = new LongOpenHashSet();
    private BiPredicate<BlockPos, BlockState> renderFilter = (pos, state) -> true;
    private final LongSet litSections = new LongOpenHashSet();
    private final BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos();
    private final Scoreboard scoreboard = new Scoreboard();
    private final ChunkSource chunkSource = new DummyChunkSource(this);
    private final Holder<Biome> biome;
    private final DataLayer defaultDataLayer;
    public static final SchemaLevel INSTANCE = new SchemaLevel();

    public SchemaLevel() {
        this(ModularUI.builtinRegistry());
    }

    public SchemaLevel(RegistryAccess registryAccess) {
        super((WritableLevelData)SchemaLevel.createLevelData(), LEVEL_ID, registryAccess, (Holder)registryAccess.m_175515_(Registries.f_256787_).m_246971_(BuiltinDimensionTypes.f_223538_), () -> InactiveProfiler.f_18554_, true, false, 0L, 1000000);
        this.biome = registryAccess.m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
        this.defaultDataLayer = new DataLayer(15);
    }

    private static ClientLevel.ClientLevelData createLevelData() {
        ClientLevel.ClientLevelData levelData = new ClientLevel.ClientLevelData(Difficulty.NORMAL, false, false);
        levelData.m_104863_(6000L);
        return levelData;
    }

    protected void prepareLighting(BlockPos pos) {
        ChunkPos minChunk = new ChunkPos(pos.m_7918_(-1, -1, -1));
        ChunkPos maxChunk = new ChunkPos(pos.m_7918_(1, 1, 1));
        ChunkPos.m_45599_((ChunkPos)minChunk, (ChunkPos)maxChunk).forEach((? super T chunkPos) -> {
            if (this.litSections.add(chunkPos.m_45588_())) {
                LevelLightEngine lightEngine = this.m_5518_();
                for (int i = 0; i < this.m_151559_(); ++i) {
                    int y = this.m_151568_(i);
                    SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)y);
                    lightEngine.m_6191_(sectionPos, false);
                    lightEngine.m_284126_(LightLayer.BLOCK, sectionPos, this.defaultDataLayer);
                    lightEngine.m_284126_(LightLayer.SKY, sectionPos, this.defaultDataLayer);
                }
                lightEngine.m_9335_(chunkPos, true);
                lightEngine.m_142519_(chunkPos);
                lightEngine.m_6462_(chunkPos, false);
            }
        });
    }

    public boolean hasFilledBlocks() {
        return !this.filledBlocks.isEmpty();
    }

    public boolean isFilledBlock(BlockPos blockPos) {
        return this.filledBlocks.contains(blockPos.m_121878_());
    }

    public Stream<BlockPos> getFilledBlocks() {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        return this.filledBlocks.longStream().sequential().mapToObj(pos -> {
            mutablePos.m_122188_(pos);
            return mutablePos;
        });
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockState>> iterator() {
        return this.getFilledBlocks().map(pos -> Map.entry(pos, this.m_8055_((BlockPos)pos))).iterator();
    }

    protected void removeFilledBlock(BlockPos pos) {
        this.filledBlocks.remove(pos.m_121878_());
    }

    protected void addFilledBlock(BlockPos pos) {
        this.filledBlocks.add(pos.m_121878_());
    }

    @Override
    public Level getLevel() {
        return this;
    }

    @Override
    public Vector3fc getFocus() {
        return BlockPosUtil.getCenterF((BlockPos)this.min, (BlockPos)this.max);
    }

    @Override
    public BlockPos getOrigin() {
        return this.min;
    }

    public boolean m_46749_(BlockPos pos) {
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        return this.chunkSource.m_5563_(chunkX, chunkZ);
    }

    @Nullable
    public Entity m_6815_(int id) {
        return (Entity)this.m_142646_().m_142597_(id);
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.entityStorage.m_157645_();
    }

    public void m_262808_(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
    }

    public void m_213890_(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void m_46672_(BlockPos pos, Block block) {
    }

    public void m_46717_(BlockPos pos, Block block) {
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable LevelChunk chunk, BlockState setState, BlockState newState, int flags, int recursionLeft) {
    }

    public String m_46464_() {
        return "";
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public void m_142325_(String mapName, MapItemSavedData data) {
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public RecipeManager m_7465_() {
        if (ModularUI.isClientThread()) {
            return ClientCallWrapper.getClientRecipeManager();
        }
        return ModularUI.getMinecraftServer().m_129894_();
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void m_214171_(GameEvent event, Vec3 position, GameEvent.Context context) {
    }

    public float m_7717_(@NotNull Direction direction, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0.5f;
            case Direction.UP -> 1.0f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
        };
    }

    public List<? extends Player> m_6907_() {
        return List.of();
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return this.biome;
    }

    public FeatureFlagSet m_246046_() {
        return FeatureFlags.f_244377_;
    }

    @Override
    @Generated
    public BiPredicate<BlockPos, BlockState> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    @Generated
    public void setRenderFilter(BiPredicate<BlockPos, BlockState> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Generated
    public Scoreboard m_6188_() {
        return this.scoreboard;
    }

    @Generated
    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    private static class EntityCallbacks
    implements LevelCallback<Entity> {
        private EntityCallbacks() {
        }

        public void onCreated(Entity entity) {
        }

        public void onDestroyed(Entity entity) {
        }

        public void onTickingStart(Entity entity) {
        }

        public void onTickingEnd(Entity entity) {
        }

        public void onTrackingStart(Entity entity) {
        }

        public void onTrackingEnd(Entity entity) {
        }

        public void onSectionChange(Entity object) {
        }
    }

    private static class ClientCallWrapper {
        private ClientCallWrapper() {
        }

        private static RecipeManager getClientRecipeManager() {
            return Minecraft.m_91087_().f_91073_.m_7465_();
        }
    }
}

