/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils.fakelevel;

import brachy.modularui.schema.ISchema;
import brachy.modularui.utils.BlockPosUtil;
import brachy.modularui.utils.fakelevel.SchemaLevel;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MapSchema
implements ISchema {
    private final Level level;
    private final Long2ReferenceOpenHashMap<BlockState> blocks = new Long2ReferenceOpenHashMap();
    private BiPredicate<BlockPos, BlockState> renderFilter = (pos, state) -> true;
    private BlockPos origin;
    private Vector3f center;

    public MapSchema(Map<BlockPos, BlockState> blocks) {
        this(blocks, null);
    }

    public MapSchema(Map<BlockPos, BlockState> blocks, BiPredicate<BlockPos, BlockState> renderFilter) {
        this(renderFilter);
        BlockPos.MutableBlockPos min = BlockPosUtil.MAX.m_122032_();
        BlockPos.MutableBlockPos max = BlockPosUtil.MIN.m_122032_();
        if (!blocks.isEmpty()) {
            for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
                if (entry.getValue().m_60795_()) continue;
                BlockPos pos = entry.getKey();
                this.blocks.put(pos.m_121878_(), (Object)entry.getValue());
                this.level.m_46597_(pos, entry.getValue());
                BlockPosUtil.setMin(min, pos);
                BlockPosUtil.setMax(max, pos);
            }
        } else {
            min.m_122178_(0, 0, 0);
            max.m_122178_(0, 0, 0);
        }
        this.origin = min.m_7949_();
        this.center = BlockPosUtil.getCenterF((BlockPos)min, (BlockPos)max);
    }

    public MapSchema(Long2ReferenceMap<BlockState> blocks) {
        this(blocks, null);
    }

    public MapSchema(Long2ReferenceMap<BlockState> blocks, BiPredicate<BlockPos, BlockState> renderFilter) {
        this(renderFilter);
        BlockPos.MutableBlockPos min = BlockPosUtil.MAX.m_122032_();
        BlockPos.MutableBlockPos max = BlockPosUtil.MIN.m_122032_();
        if (!blocks.isEmpty()) {
            for (Long2ReferenceMap.Entry entry : blocks.long2ReferenceEntrySet()) {
                if (((BlockState)entry.getValue()).m_60795_()) continue;
                BlockPos pos = BlockPos.m_122022_((long)entry.getLongKey());
                this.blocks.put(entry.getLongKey(), (Object)((BlockState)entry.getValue()));
                this.level.m_46597_(pos, (BlockState)entry.getValue());
                BlockPosUtil.setMin(min, pos);
                BlockPosUtil.setMax(max, pos);
            }
        } else {
            min.m_122178_(0, 0, 0);
            max.m_122178_(0, 0, 0);
        }
        this.origin = min.m_7949_();
        this.center = BlockPosUtil.getCenterF((BlockPos)min, (BlockPos)max);
    }

    protected MapSchema(BiPredicate<BlockPos, BlockState> renderFilter) {
        this.level = new SchemaLevel();
        if (renderFilter != null) {
            this.renderFilter = renderFilter;
        }
    }

    @Override
    public Vector3fc getFocus() {
        return this.center;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockState>> iterator() {
        return new AbstractIterator<Map.Entry<BlockPos, BlockState>>(){
            private final ObjectIterator<Long2ReferenceMap.Entry<BlockState>> it;
            {
                this.it = MapSchema.this.blocks.long2ReferenceEntrySet().fastIterator();
            }

            protected Map.Entry<BlockPos, BlockState> computeNext() {
                while (this.it.hasNext()) {
                    Long2ReferenceMap.Entry entry = (Long2ReferenceMap.Entry)this.it.next();
                    BlockPos key = BlockPos.m_122022_((long)entry.getLongKey());
                    if (!MapSchema.this.renderFilter.test(key, (BlockState)entry.getValue())) continue;
                    return Map.entry(key, (BlockState)entry.getValue());
                }
                return (Map.Entry)this.endOfData();
            }
        };
    }

    @Override
    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Generated
    public BiPredicate<BlockPos, BlockState> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    @Generated
    public void setRenderFilter(BiPredicate<BlockPos, BlockState> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Generated
    public BlockPos getOrigin() {
        return this.origin;
    }

    public static class Builder {
        private final Long2ReferenceMap<BlockState> blocks = new Long2ReferenceOpenHashMap();
        private BiPredicate<BlockPos, BlockState> renderFilter;

        public Builder add(BlockPos pos, BlockState state) {
            if (state.m_60795_()) {
                return this;
            }
            this.blocks.put(pos.m_121878_(), (Object)state);
            return this;
        }

        public Builder add(Iterable<BlockPos> posList, Function<BlockPos, BlockState> function) {
            for (BlockPos pos : posList) {
                this.add(pos, function.apply(pos));
            }
            return this;
        }

        public Builder add(Map<BlockPos, BlockState> blocks) {
            blocks.forEach((pos, state) -> this.blocks.put(pos.m_121878_(), state));
            return this;
        }

        public MapSchema build() {
            if (this.renderFilter == null) {
                return new MapSchema(this.blocks);
            }
            return new MapSchema(this.blocks, this.renderFilter);
        }

        @NotNull
        @Generated
        public Builder setRenderFilter(BiPredicate<BlockPos, BlockState> renderFilter) {
            this.renderFilter = renderFilter;
            return this;
        }
    }
}

