/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.ModularUI;
import brachy.modularui.api.ITreeNode;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.utils.ObjectList;
import brachy.modularui.widget.sizer.ResizeNode;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class TreeUtil {
    public static boolean allowUnicode = true;
    private static final String U_T = "\u2713";
    private static final String U_F = "\u2718";
    private static final String T = "T";
    private static final String F = "F";
    private static final String U_PIPE = "\u2502";
    private static final String U_PIPE_MID = "\u251c";
    private static final String U_PIPE_END = "\u2514";
    private static final String PIPE = "|";
    private static final String PIPE_MID = "+";
    private static final String PIPE_END = "-";
    public static final NodeInfo<ResizeNode> RESIZE_NODE_INFO_FULLY_RESIZED = (root, node, builder) -> builder.append("Fully resized: ").append(TreeUtil.str(node.isFullyCalculated(node.hasParent() && node.getParent().isLayout())));
    public static final NodeInfo<ResizeNode> RESIZE_NODE_INFO_RESIZED_DETAILED = (root, node, builder) -> builder.append("XYWH: ").append(TreeUtil.str(node.isXCalculated())).append(TreeUtil.str(node.isYCalculated())).append(TreeUtil.str(node.isWidthCalculated())).append(TreeUtil.str(node.isHeightCalculated())).append(", Children resized: ").append(TreeUtil.str(node.areChildrenCalculated())).append(", Self layout done: ").append(TreeUtil.str(node.isLayoutDone())).append(", Parent layout done: ").append(TreeUtil.str(!node.canRelayout(node.hasParent() && node.getParent().isLayout())));
    public static final NodeInfo<ResizeNode> RESIZE_NODE_INFO_RESIZED_COLLAPSED = (root, node, builder) -> {
        if (node.isFullyCalculated(node.hasParent() && node.getParent().isLayout())) {
            RESIZE_NODE_INFO_FULLY_RESIZED.addInfo((ResizeNode)root, (ResizeNode)node, builder);
        } else {
            RESIZE_NODE_INFO_RESIZED_DETAILED.addInfo((ResizeNode)root, (ResizeNode)node, builder);
        }
    };

    private static String str(boolean b) {
        if (allowUnicode) {
            return b ? U_T : U_F;
        }
        return b ? T : F;
    }

    public static <T extends ITreeNode<T>> boolean foreachChildBFS(T parent, Predicate<T> consumer) {
        return TreeUtil.foreachChildBFS(parent, consumer, false);
    }

    public static <T extends ITreeNode<T>> boolean foreachChildBFS(T parent, Predicate<T> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (ITreeNode child : ((ITreeNode)parents.removeFirst()).getChildren()) {
                if (child.hasChildren()) {
                    parents.addLast(child);
                }
                if (consumer.test(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T extends ITreeNode<T>> boolean foreachChild(T parent, Predicate<T> consumer) {
        return TreeUtil.foreachChild(parent, consumer, false);
    }

    public static <T extends ITreeNode<T>> boolean foreachChild(T parent, Predicate<T> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        if (!parent.hasChildren()) {
            return true;
        }
        for (ITreeNode widget : parent.getChildren()) {
            if (!consumer.test(widget)) {
                return false;
            }
            if (!widget.hasChildren() || TreeUtil.foreachChild(widget, consumer, false)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T extends ITreeNode<T>, V> V foreachChildWithResult(T parent, Function<T, V> consumer, boolean includeSelf) {
        V t;
        if (includeSelf && (t = consumer.apply(parent)) != null) {
            return t;
        }
        if (!parent.hasChildren()) {
            return null;
        }
        for (ITreeNode widget : parent.getChildren()) {
            V t2 = consumer.apply(widget);
            if (t2 != null) {
                return t2;
            }
            if (!widget.hasChildren() || (t2 = TreeUtil.foreachChildWithResult(widget, consumer, false)) == null) continue;
            return t2;
        }
        return null;
    }

    public static <T extends ITreeNode<T>> boolean foreachChildReverse(T parent, Predicate<T> consumer, boolean includeSelf) {
        if (parent.getChildren().isEmpty()) {
            return !includeSelf || consumer.test(parent);
        }
        for (ITreeNode widget : parent.getChildren()) {
            if (!widget.getChildren().isEmpty() && TreeUtil.foreachChildReverse(widget, consumer, false)) {
                return false;
            }
            if (consumer.test(widget)) continue;
            return false;
        }
        return !includeSelf || consumer.test(parent);
    }

    public static <T extends ITreeNode<T>> Stream<T> flatStreamBFS(T parent) {
        if (!parent.hasChildren()) {
            return Stream.of(parent);
        }
        return Streams.stream(TreeUtil.iteratorBFS(parent));
    }

    public static <T extends ITreeNode<T>> @UnmodifiableView Iterable<T> iterableBFS(T parent) {
        return () -> TreeUtil.iteratorBFS(parent);
    }

    public static <T extends ITreeNode<T>> @UnmodifiableView Iterator<T> iteratorBFS(final T parent) {
        return new AbstractIterator<T>(){
            private final ObjectList<T> queue = ObjectList.create();
            private Iterator<T> currentIt;

            protected T computeNext() {
                if (this.currentIt == null) {
                    this.currentIt = parent.getChildren().iterator();
                    return parent;
                }
                if (this.currentIt.hasNext()) {
                    return this.handleWidget((ITreeNode)this.currentIt.next());
                }
                while (!this.queue.isEmpty()) {
                    this.currentIt = ((ITreeNode)this.queue.removeFirst()).getChildren().iterator();
                    if (!this.currentIt.hasNext()) continue;
                    return this.handleWidget((ITreeNode)this.currentIt.next());
                }
                return (ITreeNode)this.endOfData();
            }

            private T handleWidget(T widget) {
                if (widget.hasChildren()) {
                    this.queue.add(widget);
                }
                return widget;
            }
        };
    }

    public static <T extends ITreeNode<T>> List<T> flatList(T parent, Predicate<T> test) {
        ArrayList widgets = new ArrayList();
        TreeUtil.foreachChild(parent, w -> {
            if (test.test(w)) {
                widgets.add(w);
            }
            return true;
        }, true);
        return widgets;
    }

    public static <T extends ITreeNode<T>> List<T> flatListBFS(T parent, Predicate<T> test) {
        ArrayList widgets = new ArrayList();
        TreeUtil.foreachChildBFS(parent, w -> {
            if (test.test(w)) {
                widgets.add(w);
            }
            return true;
        }, true);
        return widgets;
    }

    public static <T extends ITreeNode<T>, R extends ITreeNode<T>> List<R> flatListByType(T parent, Class<R> type) {
        return TreeUtil.flatListByType(parent, type, null);
    }

    public static <T extends ITreeNode<T>, R extends ITreeNode<T>> List<R> flatListByType(T parent, Class<R> type, @Nullable Predicate<R> test) {
        ArrayList widgets = new ArrayList();
        TreeUtil.foreachChild(parent, w -> {
            if (type.isAssignableFrom(w.getClass()) && (test == null || test.test(w))) {
                widgets.add(w);
            }
            return true;
        }, true);
        return widgets;
    }

    public static <T extends ITreeNode<T>> T findFirst(T parent, @NotNull Predicate<T> test) {
        return (T)TreeUtil.foreachChildWithResult(parent, w -> {
            if (test.test(w)) {
                return w;
            }
            return null;
        }, true);
    }

    public static <T extends ITreeNode<T>, R extends ITreeNode<T>> R findFirst(T parent, Class<R> type, @Nullable Predicate<R> test) {
        return (R)TreeUtil.foreachChildWithResult(parent, t -> {
            if (type.isAssignableFrom(t.getClass()) && (test == null || test.test(t))) {
                return t;
            }
            return null;
        }, true);
    }

    public static <T extends ITreeNode<T>> T findParent(T parent, Predicate<T> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return (T)(filter.test(parent) ? parent : null);
    }

    public static <T extends ITreeNode<T>, R extends ITreeNode<T>> R findParent(T parent, Class<R> type) {
        return TreeUtil.findParent(parent, type, null);
    }

    public static <T extends ITreeNode<T>, R extends ITreeNode<T>> R findParent(T parent, Class<R> type, @Nullable Predicate<R> test) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (type.isAssignableFrom(parent.getClass()) && (test == null || test.test(parent))) {
                return (R)parent;
            }
            parent = parent.getParent();
        }
        return type.isAssignableFrom(parent.getClass()) && (test == null || test.test(parent)) ? (R)parent : null;
    }

    public static <T extends ITreeNode<T>> void print(T parent) {
        TreeUtil.print(parent, w -> true, null);
    }

    public static <T extends ITreeNode<T>> void print(T parent, NodeInfo<T> additionalInfo) {
        TreeUtil.print(parent, w -> true, additionalInfo);
    }

    public static <T extends ITreeNode<T>> void print(T parent, Predicate<T> test) {
        TreeUtil.print(parent, test, null);
    }

    public static <T extends ITreeNode<T>> void print(T parent, Predicate<T> test, NodeInfo<T> additionalInfo) {
        StringBuilder builder = new StringBuilder();
        if (parent instanceof IWidget) {
            builder.append("Widget");
        } else if (parent instanceof ResizeNode) {
            builder.append("ResizeNode");
        } else {
            builder.append(parent.getClass());
        }
        builder.append(" tree of ").append(parent).append('\n');
        ModularUI.LOGGER.info((CharSequence)TreeUtil.toString(builder, parent, test, additionalInfo));
    }

    public static <T extends ITreeNode<T>> String toString(T parent) {
        return TreeUtil.toString(parent, w -> true, null);
    }

    public static <T extends ITreeNode<T>> String toString(T parent, NodeInfo<T> additionalInfo) {
        return TreeUtil.toString(parent, w -> true, additionalInfo);
    }

    public static <T extends ITreeNode<T>> String toString(T parent, Predicate<T> test) {
        return TreeUtil.toString(parent, test, null);
    }

    public static <T extends ITreeNode<T>> String toString(T parent, Predicate<T> test, NodeInfo<T> additionalInfo) {
        return TreeUtil.toString(null, parent, test, additionalInfo).toString();
    }

    public static <T extends ITreeNode<T>> StringBuilder toString(StringBuilder builder, T parent, Predicate<T> test, NodeInfo<T> additionalInfo) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        TreeUtil.getTree(parent, parent, test, builder, additionalInfo, "", false, null);
        return builder;
    }

    protected static <T extends ITreeNode<T>> void getTree(T root, T parent, Predicate<T> test, StringBuilder builder, NodeInfo<T> additionalInfo, String indent, boolean hasNextSibling, Set<T> visited) {
        if (!indent.isEmpty()) {
            builder.append(indent);
            if (allowUnicode) {
                builder.append(hasNextSibling ? U_PIPE_MID : U_PIPE_END);
            } else {
                builder.append(hasNextSibling ? PIPE_MID : PIPE_END);
            }
            builder.append(' ');
        }
        if (visited == null) {
            visited = new ReferenceOpenHashSet();
        }
        if (visited.contains(parent)) {
            builder.append("CYCLING TREE FOUND (").append(parent).append(")\n");
            return;
        }
        visited.add(parent);
        builder.append(parent);
        if (additionalInfo != null) {
            builder.append(" {");
            additionalInfo.addInfo(root, parent, builder);
            builder.append("}");
        }
        builder.append('\n');
        if (parent.hasChildren()) {
            List<T> children = parent.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                ITreeNode child = (ITreeNode)children.get(i);
                if (!test.test(child)) continue;
                Object nextIndent = indent;
                nextIndent = hasNextSibling ? (String)nextIndent + (allowUnicode ? U_PIPE : PIPE) + " " : (String)nextIndent + "  ";
                TreeUtil.getTree(root, child, test, builder, additionalInfo, (String)nextIndent, i < children.size() - 1, visited);
            }
        }
    }

    public static interface NodeInfo<T extends ITreeNode<T>> {
        public void addInfo(T var1, T var2, StringBuilder var3);

        default public NodeInfo<T> combine(NodeInfo<T> other, String joiner) {
            return (root, widget, builder) -> {
                this.addInfo(root, widget, builder);
                builder.append(joiner);
                other.addInfo(root, widget, builder);
            };
        }

        default public NodeInfo<T> combine(NodeInfo<T> other) {
            return this.combine(other, " | ");
        }

        @SafeVarargs
        public static <T extends ITreeNode<T>> NodeInfo<T> of(String joiner, NodeInfo<T> ... infos) {
            return (root, widget, builder) -> {
                for (int i = 0; i < infos.length; ++i) {
                    NodeInfo info = infos[i];
                    info.addInfo(root, widget, builder);
                    if (i >= infos.length - 1) continue;
                    builder.append(joiner);
                }
            };
        }

        @SafeVarargs
        public static <T extends ITreeNode<T>> NodeInfo<T> of(NodeInfo<T> ... infos) {
            return NodeInfo.of(" | ", infos);
        }
    }
}

