/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.utils.Rectangle;
import brachy.modularui.widget.sizer.Area;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Stencil {
    private static final ObjectArrayList<Area> stencils = new ObjectArrayList();
    private static final ObjectArrayList<Runnable> stencilShapes = new ObjectArrayList();
    private static int stencilValue = 0;
    private final GuiContext context;

    @ApiStatus.Internal
    public Stencil(GuiContext context) {
        this.context = context;
    }

    public static void reset() {
        RenderSystem.assertOnRenderThread();
        stencils.clear();
        stencilShapes.clear();
        stencilValue = 0;
        RenderSystem.stencilMask((int)255);
        RenderSystem.clearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
    }

    public void push(@NotNull Rectangle area) {
        this.push(area.x, area.y, area.width, area.height);
    }

    public void pushAtZero(@NotNull Rectangle area) {
        this.push(0, 0, area.width, area.height);
    }

    public void push(int x, int y, int w, int h) {
        this.push(() -> Stencil.drawRectangleStencilShape(this.context.getGraphics(), x, y, w, h), x, y, w, h);
    }

    public void push(Runnable stencilShape, boolean hideStencilShape) {
        this.push(stencilShape, 0, 0, 0, 0, hideStencilShape);
    }

    public void push(Runnable stencilShape, int x, int y, int w, int h) {
        this.push(stencilShape, x, y, w, h, true);
    }

    public void push(Runnable stencilShape, int x, int y, int w, int h, boolean hideStencilShape) {
        RenderSystem.assertOnRenderThread();
        Area scissor = new Area(x, y, w, h);
        scissor.transformAndRectanglerize(this.context);
        if (!stencils.isEmpty()) {
            ((Area)stencils.top()).clamp(scissor);
        }
        this.applyShape(stencilShape, hideStencilShape);
        stencils.add((Object)scissor);
        stencilShapes.add((Object)stencilShape);
    }

    private void applyShape(Runnable stencilShape, boolean hideStencilShape) {
        this.context.getGraphics().m_280262_();
        GL11.glEnable((int)2960);
        this.setStencilValue(stencilShape, stencilValue, false, hideStencilShape);
        RenderSystem.stencilFunc((int)515, (int)(++stencilValue), (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        this.context.getGraphics().m_280262_();
    }

    private void setStencilValue(Runnable stencilShape, int stencilValue, boolean remove, boolean hideStencilShape) {
        int mode = remove ? 7683 : 7682;
        RenderSystem.stencilFunc((int)514, (int)stencilValue, (int)255);
        RenderSystem.stencilOp((int)7680, (int)mode, (int)mode);
        RenderSystem.stencilMask((int)255);
        if (hideStencilShape) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
        }
        stencilShape.run();
        if (hideStencilShape) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.depthMask((boolean)true);
        }
    }

    private static void drawRectangleStencilShape(GuiGraphics graphics, int x, int y, int w, int h) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        ShaderInstance lastShader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::m_172808_);
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        float x0 = x;
        float x1 = x + w;
        float y0 = y;
        float y1 = y + h;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_252986_(pose, x0, y0, 0.0f).m_5752_();
        bufferbuilder.m_252986_(pose, x0, y1, 0.0f).m_5752_();
        bufferbuilder.m_252986_(pose, x1, y1, 0.0f).m_5752_();
        bufferbuilder.m_252986_(pose, x1, y0, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.setShader(() -> lastShader);
    }

    public void pop() {
        RenderSystem.assertOnRenderThread();
        if (stencils.isEmpty()) {
            throw new IllegalStateException("Tried to pop an empty stencil stack!");
        }
        stencils.pop();
        Runnable stencilShape = (Runnable)stencilShapes.pop();
        this.context.getGraphics().m_280262_();
        if (stencils.isEmpty()) {
            Stencil.reset();
            GL11.glDisable((int)2960);
            this.context.getGraphics().m_280262_();
            return;
        }
        this.setStencilValue(stencilShape, stencilValue, true, true);
        RenderSystem.stencilFunc((int)515, (int)(--stencilValue), (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        this.context.getGraphics().m_280262_();
    }

    public static boolean isInsideScissorArea(Area area, IViewportStack stack) {
        if (stencils.isEmpty()) {
            return true;
        }
        Area.SHARED.set(0, 0, area.width, area.height);
        Area.SHARED.transformAndRectanglerize(stack);
        return ((Area)stencils.top()).intersects(Area.SHARED);
    }
}

