/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.utils.Point;
import brachy.modularui.utils.PointF;
import lombok.Generated;

public class RectangleF {
    public float x;
    public float y;
    public float width;
    public float height;

    public RectangleF() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public RectangleF(RectangleF toCopy) {
        this(toCopy.x, toCopy.y, toCopy.width, toCopy.height);
    }

    public RectangleF(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public RectangleF intersect(RectangleF other) {
        float i = this.x;
        float j = this.y;
        float k = this.x + this.width;
        float l = this.y + this.height;
        float i1 = other.getX();
        float j1 = other.getY();
        float k1 = i1 + other.getWidth();
        float l1 = j1 + other.getHeight();
        this.x = Math.max(i, i1);
        this.y = Math.max(j, j1);
        this.width = Math.max(0.0f, Math.min(k, k1) - this.x);
        this.height = Math.max(0.0f, Math.min(l, l1) - this.y);
        return this;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setBounds(RectangleF toCopy) {
        this.setBounds(toCopy.x, toCopy.y, toCopy.width, toCopy.height);
    }

    public void setBounds(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public PointF getCenter() {
        return new PointF(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public boolean contains(float x, float y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public float u0() {
        return this.x;
    }

    public float v0() {
        return this.y;
    }

    public float u1() {
        return this.width;
    }

    public float v1() {
        return this.height;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public float getWidth() {
        return this.width;
    }

    @Generated
    public void setWidth(float width) {
        this.width = width;
    }

    @Generated
    public float getHeight() {
        return this.height;
    }

    @Generated
    public void setHeight(float height) {
        this.height = height;
    }
}

