/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ObjectList<V>
extends it.unimi.dsi.fastutil.objects.ObjectList<V> {
    public static <V> ObjectArrayList<V> create() {
        return new ObjectArrayList();
    }

    public static <V> ObjectArrayList<V> create(int size) {
        return new ObjectArrayList(size);
    }

    public static <V> ObjectArrayList<V> of(Collection<? extends V> c) {
        return new ObjectArrayList<V>(c);
    }

    public static <V> ObjectArrayList<V> of(ObjectCollection<? extends V> c) {
        return new ObjectArrayList<V>(c);
    }

    public static <V> ObjectArrayList<V> of(it.unimi.dsi.fastutil.objects.ObjectList<? extends V> l) {
        return new ObjectArrayList<V>(l);
    }

    public static <V> ObjectArrayList<V> of(V[] a) {
        return new ObjectArrayList<V>(a);
    }

    public static <V> ObjectArrayList<V> of(V[] a, int offset, int length) {
        return new ObjectArrayList<V>(a, offset, length);
    }

    public static <V> ObjectArrayList<V> of(Iterator<? extends V> i) {
        return new ObjectArrayList<V>(i);
    }

    public static <V> ObjectArrayList<V> of(ObjectIterator<? extends V> i) {
        return new ObjectArrayList<V>(i);
    }

    public void addFirst(V var1);

    public void addLast(V var1);

    @NotNull
    public V getFirst();

    @NotNull
    public V getLast();

    @NotNull
    public V removeFirst();

    @NotNull
    public V removeLast();

    @Nullable
    public V peekFirst();

    @Nullable
    public V pollFirst();

    @Nullable
    public V peekLast();

    @Nullable
    public V pollLast();

    public void trim();

    @NotNull
    public V[] elements();

    public void ensureCapacity(int var1);

    public static class ObjectArrayList<V>
    extends it.unimi.dsi.fastutil.objects.ObjectArrayList<V>
    implements ObjectList<V> {
        public ObjectArrayList(int capacity) {
            super(capacity);
        }

        public ObjectArrayList() {
        }

        public ObjectArrayList(Collection<? extends V> c) {
            super(c);
        }

        public ObjectArrayList(ObjectCollection<? extends V> c) {
            super(c);
        }

        public ObjectArrayList(it.unimi.dsi.fastutil.objects.ObjectList<? extends V> l) {
            super(l);
        }

        public ObjectArrayList(V[] a) {
            super((Object[])a);
        }

        public ObjectArrayList(V[] a, int offset, int length) {
            super((Object[])a, offset, length);
        }

        public ObjectArrayList(Iterator<? extends V> i) {
            super(i);
        }

        public ObjectArrayList(ObjectIterator<? extends V> i) {
            super(i);
        }

        @Override
        public void addFirst(V v) {
            this.add(0, v);
        }

        @Override
        public void addLast(V v) {
            this.add(v);
        }

        @Override
        @NotNull
        public V getFirst() {
            return (V)this.get(0);
        }

        @Override
        @NotNull
        public V getLast() {
            return (V)this.get(this.size() - 1);
        }

        @Override
        @NotNull
        public V removeFirst() {
            return (V)this.remove(0);
        }

        @Override
        @NotNull
        public V removeLast() {
            return (V)this.remove(this.size() - 1);
        }

        @Override
        public V peekFirst() {
            return this.isEmpty() ? null : (V)this.getFirst();
        }

        @Override
        public V pollFirst() {
            return this.isEmpty() ? null : (V)this.removeFirst();
        }

        @Override
        public V peekLast() {
            return this.isEmpty() ? null : (V)this.getLast();
        }

        @Override
        public V pollLast() {
            return this.isEmpty() ? null : (V)this.removeLast();
        }
    }
}

