/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.ModularUI;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    public static final Consumer<FriendlyByteBuf> EMPTY_PACKET = buffer -> {};
    private static final int MAX_ENCODED = NetworkUtils.getMaxEncodedUtfLength(Short.MAX_VALUE);

    public static boolean isClient(Player player) {
        if (player == null) {
            return ModularUI.isClientThread();
        }
        return player.m_9236_().f_46443_;
    }

    public static void writeByteBuf(FriendlyByteBuf writeTo, ByteBuf writeFrom) {
        writeTo.m_130130_(writeFrom.readableBytes());
        writeTo.writeBytes(writeFrom.slice());
    }

    public static ByteBuf readByteBuf(FriendlyByteBuf buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.m_130242_());
        return Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
    }

    public static FriendlyByteBuf readFriendlyByteBuf(FriendlyByteBuf buf) {
        return new FriendlyByteBuf(NetworkUtils.readByteBuf(buf));
    }

    public static void writeStringSafe(FriendlyByteBuf buffer, String string) {
        NetworkUtils.writeStringSafe(buffer, string, Short.MAX_VALUE, false);
    }

    public static void writeStringSafe(FriendlyByteBuf buffer, @Nullable String string, boolean crash) {
        NetworkUtils.writeStringSafe(buffer, string, Short.MAX_VALUE, crash);
    }

    public static void writeStringSafe(FriendlyByteBuf buffer, @Nullable String string, int maxBytes) {
        NetworkUtils.writeStringSafe(buffer, string, maxBytes, false);
    }

    public static void writeStringSafe(FriendlyByteBuf buffer, @Nullable String string, int maxBytes, boolean crash) {
        byte[] bytes;
        int maxEncoded;
        if (string == null) {
            buffer.m_130130_(MAX_ENCODED + 1);
            return;
        }
        if (string.isEmpty()) {
            buffer.m_130130_(0);
            return;
        }
        maxBytes = Math.min(maxBytes, Short.MAX_VALUE);
        byte[] bytesTest = string.getBytes(StandardCharsets.UTF_8);
        if (bytesTest.length > (maxEncoded = NetworkUtils.getMaxEncodedUtfLength(maxBytes))) {
            if (crash) {
                throw new IllegalArgumentException("Max String size is " + maxEncoded + ", but found " + bytesTest.length + " bytes for '" + string + "'!");
            }
            bytes = new byte[maxEncoded];
            System.arraycopy(bytesTest, 0, bytes, 0, maxEncoded);
            ModularUI.LOGGER.warn("Warning! Synced string exceeds max length!");
        } else {
            bytes = bytesTest;
        }
        buffer.m_130130_(bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readStringSafe(FriendlyByteBuf buffer) {
        int length = buffer.m_130242_();
        if (length > MAX_ENCODED) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        String s = buffer.toString(buffer.readerIndex(), length, StandardCharsets.UTF_8);
        buffer.readerIndex(buffer.readerIndex() + length);
        return s;
    }

    private static int getMaxEncodedUtfLength(int maxLength) {
        return maxLength * 3;
    }
}

