/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record KeyboardData(Dist side, int keyCode, int scanCode, int modifiers) {
    public boolean hasControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean hasShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean hasAltDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isClient() {
        return this.side.isClient();
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.keyCode);
        buffer.m_130130_(this.scanCode);
        buffer.m_130130_(this.modifiers);
    }

    public static KeyboardData readPacket(FriendlyByteBuf buffer) {
        int keyCode = buffer.m_130242_();
        int scanCode = buffer.m_130242_();
        int modifiers = buffer.m_130242_();
        return new KeyboardData(Dist.DEDICATED_SERVER, keyCode, scanCode, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static KeyboardData create(int keyCode, int scanCode, int modifiers) {
        return new KeyboardData(Dist.CLIENT, keyCode, scanCode, modifiers);
    }
}

