/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.utils.serialization.network.IByteBufAdapter;
import brachy.modularui.utils.serialization.network.IByteBufDeserializer;
import brachy.modularui.utils.serialization.network.IByteBufSerializer;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;

public interface ICopy<T> {
    public static <T> ICopy<T> immutable() {
        return t -> t;
    }

    public static <T> ICopy<T> ofSerializer(IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
        return t -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            serializer.serialize(buf, t);
            return deserializer.deserialize(buf);
        };
    }

    public static <T> ICopy<T> ofSerializer(IByteBufAdapter<T> adapter) {
        return ICopy.ofSerializer(adapter, adapter);
    }

    public T createDeepCopy(T var1);

    public static <T> ICopy<T> wrapNullSafe(ICopy<T> copy) {
        return t -> t == null ? null : copy.createDeepCopy(t);
    }
}

