/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.utils.MathUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GTMatrixUtils {
    private static final ImmutableMap<Direction, Vector3fc> directionAxises = (ImmutableMap)Util.m_137537_(() -> {
        ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)6);
        for (Direction dir : Direction.values()) {
            map.put((Object)dir, (Object)dir.m_253071_());
        }
        return map.build();
    });
    private static final Table<Direction, Direction, Matrix4fc> rotations = Tables.synchronizedTable((Table)HashBasedTable.create());
    private static final ByteBuffer PIXEL_DEPTH_BUFFER = GlUtil.m_166247_((int)4);
    private static final int[] VIEWPORT_COORDS = new int[]{0, 0, 0, 0};

    @Contract(pure=true)
    public static float getRotationAngle(Vector3fc from, Vector3fc to) {
        return (float)Math.acos(from.dot(to));
    }

    public static Vector3f getRotationAxis(Vector3f from, Vector3fc to) {
        return GTMatrixUtils.getRotationAxis((Vector3fc)from, to, from);
    }

    public static Vector3f getRotationAxis(Vector3fc from, Vector3fc to, Vector3f dest) {
        return from.cross(to, dest).normalize();
    }

    @Contract(pure=true)
    public static Quaternionf getRotation(Vector3fc from, Vector3fc to) {
        return from.rotationTo(to, new Quaternionf());
    }

    @Contract(pure=true)
    public static Quaternionf getRotation(Direction from, Direction to) {
        return GTMatrixUtils.getRotation(GTMatrixUtils.getDirectionAxis(from), GTMatrixUtils.getDirectionAxis(to));
    }

    public static void rotateMatrix(Matrix4f matrix, Vector3f from, Vector3fc to, Vector3f ... additional) {
        if (from.equals((Object)to)) {
            return;
        }
        if (-from.x() == to.x() && -from.y() == to.y() && -from.z() == to.z()) {
            GTMatrixUtils.rotateMatrix(matrix, (float)Math.PI, GTMatrixUtils.getDirectionAxis(Direction.UP), additional);
        } else {
            float angle = GTMatrixUtils.getRotationAngle((Vector3fc)from, to);
            GTMatrixUtils.getRotationAxis(from, to);
            GTMatrixUtils.rotateMatrix(matrix, angle, (Vector3fc)from, additional);
        }
    }

    public static void rotateMatrix(Matrix4f matrix, float angle, Vector3fc axis, Vector3f ... additional) {
        matrix.rotate(angle, axis);
        for (Vector3f vec : additional) {
            vec.rotateAxis(angle, axis.x(), axis.y(), axis.z());
        }
    }

    public static float upwardFacingAngle(Direction upward) {
        return (switch (upward) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 2.0f;
            case Direction.WEST -> 3.0f;
            case Direction.EAST -> 1.0f;
            default -> throw new InvalidParameterException("Upward facing can't be up/down");
        }) * 1.5707964f;
    }

    public static Vector3f rotateMatrixToFront(Matrix4f matrix, Direction frontFace) {
        Vector3f front = frontFace.m_253071_();
        GTMatrixUtils.rotateMatrix(matrix, Direction.NORTH.m_253071_(), GTMatrixUtils.getDirectionAxis(frontFace), front);
        return front;
    }

    public static void rotateMatrixToUp(Matrix4f matrix, Vector3fc front, Direction upwardsFace) {
        GTMatrixUtils.rotateMatrix(matrix, GTMatrixUtils.upwardFacingAngle(upwardsFace), front, new Vector3f[0]);
    }

    public static Matrix4fc createRotationState(Direction frontFace, Direction upwardFace) {
        if (rotations.contains((Object)frontFace, (Object)upwardFace)) {
            Matrix4fc rotation = (Matrix4fc)rotations.get((Object)frontFace, (Object)upwardFace);
            assert (rotation != null);
            return rotation;
        }
        Matrix4f matrix = new Matrix4f();
        Vector3f front = GTMatrixUtils.rotateMatrixToFront(matrix, frontFace);
        front.absolute();
        GTMatrixUtils.rotateMatrixToUp(matrix, (Vector3fc)front, upwardFace);
        rotations.put((Object)frontFace, (Object)upwardFace, (Object)matrix);
        return matrix;
    }

    public static Vector3fc getDirectionAxis(Direction dir) {
        return Objects.requireNonNull((Vector3fc)directionAxises.get((Object)dir));
    }

    public static Matrix4f lookAt(Vector3fc eyePos, Vector3fc target) {
        return new Matrix4f().lookAt(eyePos, target, MathUtil.UNIT_Y);
    }

    public static void lookAt(PoseStack poseStack, Vector3fc eyePos, Vector3fc target) {
        GTMatrixUtils.lookAt(poseStack.m_85850_(), eyePos, target);
    }

    public static void lookAt(PoseStack.Pose pose, Vector3fc eyePos, Vector3fc target) {
        pose.m_252922_().lookAt(eyePos, target, MathUtil.UNIT_Y);
        pose.m_252943_().lookAlong(target, MathUtil.UNIT_Y);
    }

    public static Vector3f projectWorldToScreen(Vector3fc worldPos) {
        Window window = Minecraft.m_91087_().m_91268_();
        return GTMatrixUtils.projectWorldToScreen(worldPos, window.m_85441_(), window.m_85442_());
    }

    public static Vector3f projectWorldToScreen(Vector3fc worldPos, int viewWidth, int viewHeight) {
        Matrix4f transform = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).mul((Matrix4fc)RenderSystem.getModelViewMatrix());
        Vector3f screenPos = new Vector3f(worldPos).mulPosition((Matrix4fc)transform);
        screenPos.x = (float)viewWidth * (screenPos.x + 1.0f) / 2.0f;
        screenPos.y = (float)viewHeight * (screenPos.y + 1.0f) / 2.0f;
        screenPos.z = (screenPos.z + 1.0f) / 2.0f;
        return screenPos;
    }

    public static Vector3f projectScreenToWorld(int x, int y) {
        Window window = Minecraft.m_91087_().m_91268_();
        return GTMatrixUtils.projectScreenToWorld(x, y, window.m_85441_(), window.m_85442_(), true);
    }

    public static Vector3f projectScreenToWorld(int x, int y, int viewWidth, int viewHeight, boolean checkDepth) {
        GTMatrixUtils.VIEWPORT_COORDS[2] = viewWidth;
        GTMatrixUtils.VIEWPORT_COORDS[3] = viewHeight;
        return GTMatrixUtils.projectScreenToWorld(x, y, VIEWPORT_COORDS, checkDepth);
    }

    public static Vector3f projectScreenToWorld(int x, int y, int[] viewport, boolean checkDepth) {
        Matrix4f transform = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).mul((Matrix4fc)RenderSystem.getModelViewMatrix());
        float depth = 1.0f;
        if (checkDepth) {
            RenderSystem.readPixels((int)x, (int)y, (int)1, (int)1, (int)6402, (int)5126, (ByteBuffer)PIXEL_DEPTH_BUFFER);
            PIXEL_DEPTH_BUFFER.rewind();
            depth = PIXEL_DEPTH_BUFFER.getFloat();
            PIXEL_DEPTH_BUFFER.rewind();
        }
        return transform.unproject((float)x, (float)y, depth, viewport, new Vector3f());
    }
}

