/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;

public class Alignment {
    private static final Map<String, Alignment> ALIGNMENT_MAP = new Object2ObjectOpenHashMap();
    public final float x;
    public final float y;
    public static final Alignment TopLeft = new Alignment(0.0f, 0.0f, "TopLeft");
    public static final Alignment TopCenter = new Alignment(0.5f, 0.0f, "TopCenter");
    public static final Alignment TopRight = new Alignment(1.0f, 0.0f, "TopRight");
    public static final Alignment CenterLeft = new Alignment(0.0f, 0.5f, "CenterLeft");
    public static final Alignment Center = new Alignment(0.5f, 0.5f, "Center");
    public static final Alignment CenterRight = new Alignment(1.0f, 0.5f, "CenterRight");
    public static final Alignment BottomLeft = new Alignment(0.0f, 1.0f, "BottomLeft");
    public static final Alignment BottomCenter = new Alignment(0.5f, 1.0f, "BottomCenter");
    public static final Alignment BottomRight = new Alignment(1.0f, 1.0f, "BottomRight");
    public static final Alignment START = TopLeft;
    public static final Alignment CENTER = Center;
    public static final Alignment END = BottomRight;
    public static final Alignment[] ALL = new Alignment[]{TopLeft, TopCenter, TopRight, CenterLeft, Center, CenterRight, BottomLeft, BottomCenter, BottomRight};
    public static final Alignment[] CORNERS = new Alignment[]{TopLeft, TopRight, BottomLeft, BottomRight};

    public Alignment(float x, float y) {
        this(x, y, null);
    }

    private Alignment(float x, float y, String name) {
        this.x = x;
        this.y = y;
        if (name != null) {
            ALIGNMENT_MAP.put(name, this);
            ALIGNMENT_MAP.put(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name), this);
            String abbrev = name.replaceAll("[a-z]", "");
            ALIGNMENT_MAP.put(abbrev, this);
            ALIGNMENT_MAP.put(abbrev.toLowerCase(), this);
        }
    }

    public static class Json
    implements JsonDeserializer<Alignment>,
    JsonSerializer<Alignment> {
        public Alignment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                Alignment alignment = ALIGNMENT_MAP.get(json.getAsString());
                if (alignment == null) {
                    throw new JsonParseException("Can't find alignment for " + json.getAsString());
                }
                return alignment;
            }
            float x = JsonHelper.getFloat(json.getAsJsonObject(), 0.0f, "x");
            float y = JsonHelper.getFloat(json.getAsJsonObject(), 0.0f, "y");
            return new Alignment(x, y);
        }

        public JsonElement serialize(Alignment src, Type typeOfSrc, JsonSerializationContext context) {
            for (Map.Entry<String, Alignment> entry : ALIGNMENT_MAP.entrySet()) {
                if (entry.getValue() != src) continue;
                return new JsonPrimitive(entry.getKey());
            }
            return JsonHelper.makeJson(json -> {
                json.addProperty("x", (Number)Float.valueOf(src.x));
                json.addProperty("y", (Number)Float.valueOf(src.y));
            });
        }
    }

    public static enum CrossAxis {
        START,
        CENTER,
        END;

    }

    public static enum MainAxis {
        START,
        CENTER,
        END,
        SPACE_BETWEEN,
        SPACE_AROUND;

    }
}

