/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.ModularUI;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.theme.ReloadThemeEvent;
import brachy.modularui.theme.Theme;
import brachy.modularui.theme.ThemeAPI;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.theme.WidgetThemeMap;
import brachy.modularui.theme.WidgetThemeParser;
import brachy.modularui.utils.serialization.json.JsonBuilder;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ThemeManager
extends SimplePreparableReloadListener<Map<String, List<ResourceLocation>>> {
    public static final String THEMES_PATH = "themes.json";
    public static final FileToIdConverter THEME_LISTER = FileToIdConverter.m_246568_((String)"themes");
    protected static final WidgetThemeEntry<WidgetTheme> defaultFallbackWidgetTheme = IThemeApi.get().getDefaultTheme().getWidgetTheme(IThemeApi.FALLBACK);
    private static final JsonObject emptyJson = new JsonObject();

    public static void reload() {
        ThemeManager themeManager = new ThemeManager();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        themeManager.apply(themeManager.prepare(resourceManager, profiler), resourceManager, profiler);
    }

    @NotNull
    protected Map<String, List<ResourceLocation>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ModularUI.LOGGER.info("Reloading Themes...");
        MinecraftForge.EVENT_BUS.post((Event)new ReloadThemeEvent.Pre());
        ThemeAPI.INSTANCE.onReload();
        Object2ObjectOpenHashMap themes = new Object2ObjectOpenHashMap();
        profiler.m_7242_();
        ArrayList<String> themeJsonSources = new ArrayList<String>();
        for (String namespace : resourceManager.m_7187_()) {
            profiler.m_6180_(namespace);
            for (Resource resource : resourceManager.m_213829_(new ResourceLocation(namespace, THEMES_PATH))) {
                JsonElement element;
                profiler.m_6180_(resource.m_215506_());
                themeJsonSources.add(resource.m_215506_());
                try (InputStream stream = resource.m_215507_();){
                    element = JsonHelper.parse(stream);
                }
                catch (Exception e) {
                    ModularUI.LOGGER.catching((Throwable)e);
                    continue;
                }
                if (!element.isJsonObject()) continue;
                JsonObject definitions = element.getAsJsonObject();
                for (Map.Entry entry : definitions.entrySet()) {
                    if (((String)entry.getKey()).equals("screens")) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) {
                            ModularUI.LOGGER.error("Theme screen definitions must be an object!");
                            continue;
                        }
                        ThemeManager.loadScreenThemes(((JsonElement)entry.getValue()).getAsJsonObject());
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonArray() || ((JsonElement)entry.getValue()).isJsonNull()) {
                        ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a string!"));
                        continue;
                    }
                    themes.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(new ResourceLocation(((JsonElement)entry.getValue()).getAsString()));
                }
                profiler.m_7238_();
            }
            profiler.m_7238_();
        }
        ModularUI.LOGGER.info("Found themes.json's at {}", themeJsonSources);
        return themes;
    }

    protected void apply(@NotNull Map<String, List<ResourceLocation>> themes, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        boolean changed;
        Object2ObjectOpenHashMap themeMap = new Object2ObjectOpenHashMap();
        profiler.m_7242_();
        for (Map.Entry<String, List<ResourceLocation>> entry : themes.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            profiler.m_6180_(entry.getKey());
            ThemeJson theme = ThemeManager.loadThemeJson(entry.getKey(), entry.getValue(), resourceManager, profiler);
            if (theme != null) {
                themeMap.put(entry.getKey(), theme);
            }
            profiler.m_7238_();
        }
        for (Map.Entry entry : ThemeAPI.INSTANCE.defaultThemes.entrySet()) {
            if (themeMap.containsKey(entry.getKey())) continue;
            themeMap.put((String)entry.getKey(), new ThemeJson((String)entry.getKey(), ((List)entry.getValue()).stream().map(JsonBuilder::getJson).collect(Collectors.toList()), false));
        }
        if (themeMap.isEmpty()) {
            return;
        }
        ThemeManager.validateAncestorTree((Map<String, ThemeJson>)themeMap);
        if (themeMap.isEmpty()) {
            return;
        }
        Object2ObjectLinkedOpenHashMap sortedThemes = new Object2ObjectLinkedOpenHashMap();
        block2: do {
            changed = false;
            Iterator iterator = themeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!"DEFAULT".equals(((ThemeJson)entry.getValue()).parent) && !sortedThemes.containsKey(((ThemeJson)entry.getValue()).parent)) continue;
                sortedThemes.put((String)entry.getKey(), (ThemeJson)entry.getValue());
                iterator.remove();
                changed = true;
                continue block2;
            }
        } while (changed);
        for (ThemeJson themeJson : sortedThemes.values()) {
            Theme theme = themeJson.deserialize();
            ThemeAPI.INSTANCE.registerTheme(theme);
        }
        ThemeManager.validateJsonScreenThemes();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadThemeEvent.Post());
    }

    private static void validateAncestorTree(Map<String, ThemeJson> themeMap) {
        ObjectOpenHashSet invalidThemes = new ObjectOpenHashSet();
        block0: for (ThemeJson theme : themeMap.values()) {
            if (invalidThemes.contains(theme)) continue;
            ObjectOpenHashSet parents = new ObjectOpenHashSet();
            parents.add(theme);
            ThemeJson parent = theme;
            while (!"DEFAULT".equals(parent.parent)) {
                parent = themeMap.get(parent.parent);
                if (parent == null) {
                    ModularUI.LOGGER.error("Can't find parent '{}' for theme '{}'! All children for '{}' are therefore invalid!", (Object)theme.parent, (Object)theme.id, (Object)theme.id);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (parents.contains(parent)) {
                    ModularUI.LOGGER.error("Ancestor tree for themes can't be circular! All of the following make a circle or are children of the circle: {}", (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                if (invalidThemes.contains(parent)) {
                    ModularUI.LOGGER.error("Parent '{}' was found to be invalid before. All following are children of it and are therefore invalid too: {}", (Object)theme.parent, (Object)parents);
                    invalidThemes.addAll(parents);
                    continue block0;
                }
                parents.add(parent);
            }
        }
        for (ThemeJson theme : invalidThemes) {
            themeMap.remove(theme.id);
        }
    }

    private static ThemeJson loadThemeJson(String id, List<ResourceLocation> paths, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
        boolean override = false;
        for (ResourceLocation path : paths) {
            JsonElement element;
            profiler.m_6180_(path.toString());
            ResourceLocation rl = THEME_LISTER.m_245698_(path);
            Resource resource = resourceManager.m_213713_(rl).orElse(null);
            if (resource == null) {
                profiler.m_7238_();
                ModularUI.LOGGER.warn("Theme '{}' was not found at path '{}'", (Object)id, (Object)rl);
                continue;
            }
            try (InputStream stream = resource.m_215507_();){
                element = JsonHelper.parse(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (element.isJsonObject()) {
                if (JsonHelper.getBoolean(element.getAsJsonObject(), false, "override")) {
                    jsons.clear();
                    override = true;
                }
                jsons.add(element.getAsJsonObject());
            }
            profiler.m_7238_();
        }
        if (jsons.isEmpty()) {
            ModularUI.LOGGER.throwing((Throwable)new JsonParseException("Theme must be a JsonObject!"));
            return null;
        }
        return new ThemeJson(id, jsons, override);
    }

    private static void loadScreenThemes(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                String theme = ((JsonElement)entry.getValue()).getAsString();
                ThemeAPI.INSTANCE.jsonScreenThemes.put((Object)((String)entry.getKey()), (Object)theme);
                continue;
            }
            ModularUI.LOGGER.error("Theme screen definitions must be strings!");
        }
    }

    private static void validateJsonScreenThemes() {
        ObjectIterator iterator = ThemeAPI.INSTANCE.jsonScreenThemes.object2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ThemeAPI.INSTANCE.hasTheme((String)entry.getValue())) continue;
            ModularUI.LOGGER.error("Tried to register theme '{}' for screen '{}', but theme does not exist", entry.getValue(), entry.getKey());
            iterator.remove();
        }
    }

    private static class ThemeJson {
        private final String id;
        private final String parent;
        private final List<JsonObject> jsons;
        private final boolean override;

        private ThemeJson(String id, List<JsonObject> jsons, boolean override) {
            this.id = id;
            this.override = override;
            String p = null;
            ListIterator<JsonObject> iterator = jsons.listIterator(jsons.size());
            while (iterator.hasPrevious()) {
                JsonObject json = iterator.previous();
                if (!json.has("parent")) continue;
                p = json.get("parent").getAsString();
                break;
            }
            this.parent = p == null ? "DEFAULT" : p;
            this.jsons = jsons;
        }

        private Theme deserialize() {
            WidgetTheme fallback;
            if (!ThemeAPI.INSTANCE.hasTheme(this.parent)) {
                throw new IllegalStateException(String.format("Ancestor tree was validated, but parent '%s' was still null during parsing!", this.parent));
            }
            ITheme parent = ThemeAPI.INSTANCE.getTheme(this.parent);
            JsonBuilder jsonBuilder = new JsonBuilder();
            if (!this.override) {
                for (JsonBuilder builder : ThemeAPI.INSTANCE.getJavaDefaultThemes(this.id)) {
                    jsonBuilder.addAllOf(builder);
                }
            }
            for (JsonObject json : this.jsons) {
                jsonBuilder.addAllOf(json);
            }
            WidgetThemeMap widgetThemes = new WidgetThemeMap();
            WidgetThemeEntry<WidgetTheme> parentWidgetTheme = parent.getFallback();
            WidgetTheme fallbackHover = fallback = new WidgetTheme(parentWidgetTheme.theme(), jsonBuilder.getJson(), null);
            JsonObject hoverJson = this.getJson(jsonBuilder.getJson(), ":hover");
            if (hoverJson == null) {
                hoverJson = this.getJson(jsonBuilder.getJson(), IThemeApi.FALLBACK.getFullName() + ":hover");
            }
            if (hoverJson != null) {
                fallbackHover = new WidgetTheme(fallback, hoverJson, null);
            }
            widgetThemes.putTheme(IThemeApi.FALLBACK, new WidgetThemeEntry<WidgetTheme>(IThemeApi.FALLBACK, fallback, fallbackHover));
            for (WidgetThemeKey<?> key : ThemeAPI.INSTANCE.getWidgetThemeKeys()) {
                if (key == IThemeApi.FALLBACK) continue;
                this.parse(widgetThemes, parent, key, jsonBuilder);
            }
            return new Theme(this.id, parent, widgetThemes);
        }

        private <T extends WidgetTheme> void parse(WidgetThemeMap map, ITheme parent, WidgetThemeKey<T> key, JsonBuilder json) {
            T widgetTheme;
            JsonObject fallback;
            boolean definedHover;
            WidgetThemeParser<T> parser = key.getParser();
            JsonObject widgetThemeJson = this.getJson(json.getJson(), key.getFullName());
            boolean definedStandard = widgetThemeJson != null;
            JsonObject widgetThemeHoverJson = this.getJson(json.getJson(), key.getFullName() + ":hover");
            boolean bl = definedHover = widgetThemeHoverJson != null;
            if (!definedHover && !definedStandard) {
                if (key.isSubWidgetTheme()) {
                    WidgetThemeEntry<T> entry = map.getTheme(key.getParent());
                    map.putTheme(key, new WidgetThemeEntry<T>(key, entry.theme(), entry.hoverTheme()));
                    return;
                }
                widgetThemeJson = emptyJson;
                widgetThemeHoverJson = emptyJson;
            }
            JsonObject jsonObject = fallback = key.isSubWidgetTheme() ? null : json.getJson();
            if (widgetThemeJson != null) {
                T parentWidgetTheme = key.isSubWidgetTheme() ? map.getTheme(key.getParent()).theme() : parent.getWidgetTheme(key).theme();
                widgetTheme = parser.parse(parentWidgetTheme, widgetThemeJson, fallback);
            } else {
                widgetTheme = parent.getWidgetTheme(key).theme();
            }
            if (!definedHover && definedStandard) {
                widgetThemeJson.addProperty("background", "none");
                widgetThemeHoverJson = widgetThemeJson;
            }
            T parentWidgetHoverTheme = widgetThemeJson != null ? widgetTheme : parent.getWidgetTheme(key).hoverTheme();
            T widgetThemeHover = parser.parse(parentWidgetHoverTheme, widgetThemeHoverJson, fallback);
            map.putTheme(key, new WidgetThemeEntry<T>(key, widgetTheme, widgetThemeHover));
        }

        private JsonObject getJson(JsonObject json, String key) {
            if (json.has(key)) {
                JsonElement element = json.get(key);
                if (element.isJsonObject()) {
                    return element.getAsJsonObject();
                }
                ModularUI.LOGGER.warn("WidgetTheme '{}' of theme '{}' with parent '{}' was found to have an incorrect data format.", (Object)key, (Object)this.id, (Object)this.parent);
            }
            return null;
        }
    }
}

