/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.theme.AbstractTheme;
import brachy.modularui.theme.DefaultTheme;
import brachy.modularui.theme.ThemeManager;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.theme.WidgetThemeKey;
import brachy.modularui.theme.WidgetThemeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.UnmodifiableView;

public class Theme
extends AbstractTheme {
    private final WidgetThemeMap widgetThemes;

    Theme(String id, ITheme parent, WidgetThemeMap widgetThemes) {
        block4: {
            block3: {
                super(id, parent);
                this.widgetThemes = new WidgetThemeMap();
                this.widgetThemes.putAll((Map)((Object)widgetThemes));
                if (!(parent instanceof Theme)) break block3;
                Theme theme = (Theme)parent;
                for (WidgetThemeEntry entry : theme.widgetThemes.values()) {
                    if (this.widgetThemes.containsKey(entry.key())) continue;
                    this.widgetThemes.put(entry.key(), entry);
                }
                break block4;
            }
            if (parent != DefaultTheme.INSTANCE) break block4;
            if (!this.widgetThemes.containsKey(IThemeApi.FALLBACK)) {
                this.widgetThemes.putTheme(IThemeApi.FALLBACK, ThemeManager.defaultFallbackWidgetTheme);
            }
            for (WidgetThemeEntry<?> entry : DefaultTheme.INSTANCE.getWidgetThemes()) {
                if (this.widgetThemes.containsKey(entry.key())) continue;
                this.widgetThemes.put(entry.key(), entry);
            }
        }
    }

    @Override
    public @UnmodifiableView Collection<WidgetThemeEntry<?>> getWidgetThemes() {
        return Collections.unmodifiableCollection(this.widgetThemes.values());
    }

    @Override
    public <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(WidgetThemeKey<T> key) {
        WidgetThemeEntry<T> widgetTheme = this.widgetThemes.getTheme(key);
        while (widgetTheme == null && key.isSubWidgetTheme()) {
            widgetTheme = this.widgetThemes.getTheme(key.getParent());
        }
        return widgetTheme;
    }
}

