/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.theme;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeBuilder;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class TextFieldTheme
extends WidgetTheme {
    private final int markedColor;
    private final int hintColor;

    public TextFieldTheme(int markedColor, int hintColor) {
        this(56, 18, GuiTextures.DISPLAY_SMALL, Color.WHITE.main, Color.WHITE.main, false, Color.WHITE.main, markedColor, hintColor);
    }

    public TextFieldTheme(int defaultWidth, int defaultHeight, @Nullable IDrawable background, int color, int textColor, boolean textShadow, int iconColor, int markedColor, int hintColor) {
        super(defaultWidth, defaultHeight, background, color, textColor, textShadow, iconColor);
        this.markedColor = markedColor;
        this.hintColor = hintColor;
    }

    public TextFieldTheme(TextFieldTheme parent, JsonObject json, JsonObject fallback) {
        super(parent, json, fallback);
        this.markedColor = JsonHelper.getColorWithFallback(json, fallback, parent.getMarkedColor(), "markedColor");
        this.hintColor = JsonHelper.getColorWithFallback(json, fallback, parent.getHintColor(), "hintColor");
    }

    @Override
    public WidgetTheme withNoHoverBackground() {
        return new TextFieldTheme(this.getDefaultWidth(), this.getDefaultHeight(), IDrawable.NONE, this.getColor(), this.getTextColor(), this.isTextShadow(), this.getIconColor(), this.markedColor, this.hintColor);
    }

    @Generated
    public int getMarkedColor() {
        return this.markedColor;
    }

    @Generated
    public int getHintColor() {
        return this.hintColor;
    }

    public static class Builder<T extends TextFieldTheme, B extends Builder<T, B>>
    extends WidgetThemeBuilder<T, B> {
        public B markedColor(int markedColor) {
            this.add("markedColor", markedColor);
            return (B)((Builder)this.getThis());
        }

        public B hintColor(int hintColor) {
            this.add("hintColor", hintColor);
            return (B)((Builder)this.getThis());
        }
    }
}

