/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.test;

import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.IUIHolder;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.drawable.Rectangle;
import brachy.modularui.factory.PlayerInventoryGuiData;
import brachy.modularui.factory.inventory.InventoryTypes;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.UISettings;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.Color;
import brachy.modularui.utils.ColorShade;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.value.sync.SyncHandlers;
import brachy.modularui.widget.ParentWidget;
import brachy.modularui.widget.Widget;
import brachy.modularui.widgets.ButtonWidget;
import brachy.modularui.widgets.ColorPickerDialog;
import brachy.modularui.widgets.CycleButtonWidget;
import brachy.modularui.widgets.SlotGroupWidget;
import brachy.modularui.widgets.TextWidget;
import brachy.modularui.widgets.layout.Column;
import brachy.modularui.widgets.layout.Flow;
import brachy.modularui.widgets.slot.ItemSlot;
import brachy.modularui.widgets.slot.ModularSlot;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TestItem
extends Item
implements ICurioItem,
IUIHolder<PlayerInventoryGuiData<?>> {
    public TestItem(Item.Properties properties) {
        super(properties);
        CuriosApi.registerCurio((Item)this, (ICurioItem)this);
    }

    @Override
    public ModularScreen createScreen(PlayerInventoryGuiData<?> data, ModularPanel mainPanel) {
        return new ModularScreen("modularui", mainPanel);
    }

    @Override
    public ModularPanel buildUI(PlayerInventoryGuiData<?> data, PanelSyncManager syncManager, UISettings settings) {
        LazyOptional cap = data.getUsedItemStack().getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!cap.isPresent() || cap.resolve().isEmpty()) {
            return null;
        }
        IItemHandler itemHandler = (IItemHandler)cap.resolve().get();
        syncManager.registerSlotGroup("mixer_items", 2);
        if (!(itemHandler instanceof IItemHandlerModifiable)) {
            return null;
        }
        IItemHandlerModifiable ihm = (IItemHandlerModifiable)itemHandler;
        if (data.getInventoryType() == InventoryTypes.PLAYER) {
            syncManager.bindPlayerInventory(data.getPlayer(), (inv, index) -> index == data.getSlotIndex() ? new ModularSlot((IItemHandler)inv, index).accessibility(false, false) : new ModularSlot((IItemHandler)inv, index));
        }
        ModularPanel panel = ModularPanel.defaultPanel("knapping_gui").resizeableOnDrag(true);
        ((ModularPanel)panel.child((IWidget)((Flow)((Flow)new Column().margin(7)).child((IWidget)((ParentWidget)((ParentWidget)new ParentWidget().widthRel(1.0f)).expanded()).child((IWidget)SlotGroupWidget.builder().row("I I").row("  I").row("   ").row(" I ").key('I', index -> new ItemSlot().slot(SyncHandlers.itemSlot(ihm, index).ignoreMaxStackSize(true).slotGroup("mixer_items").filter(stack -> !stack.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()))).build().align(Alignment.TopLeft)))).child(SlotGroupWidget.playerInventory(false)))).child((IWidget)((Widget)((Widget)GuiTextures.ANIMATED_TEXTURE_TEST.asWidget().size(32)).align(Alignment.TopRight)).margin(7));
        return panel;
    }

    @NotNull
    public ModularPanel buildColorUI(ModularGuiContext context) {
        ArrayList<Pair> colors = new ArrayList<Pair>();
        for (ColorShade shade : ColorShade.getAll()) {
            IntIterator intIterator = shade.iterator();
            while (intIterator.hasNext()) {
                int c = (Integer)intIterator.next();
                colors.add(Pair.of((Object)c, (Object)Float.valueOf(Color.getLuminance(c))));
            }
        }
        colors.sort((a, b) -> Float.compare(((Float)a.getRight()).floatValue(), ((Float)b.getRight()).floatValue()));
        IDrawable luminanceSortedColors = (context1, x, y, width, height, widgetTheme) -> {
            float w = (float)width / (float)colors.size();
            float x0 = x;
            for (Pair c : colors) {
                GuiDraw.drawRect(context.getGraphics(), x0, y, w, height, (Integer)c.getLeft());
                x0 += w;
            }
        };
        Rectangle color1 = new Rectangle().color(Color.BLACK.main);
        Rectangle color2 = new Rectangle().color(Color.WHITE.main);
        IDrawable gradient = (context1, x, y, width, height, widgetTheme) -> GuiDraw.drawHorizontalGradientRect(context1.getGraphics(), x, y, width, height, color1.getColor(), color2.getColor());
        IDrawable correctedGradient = (context1, x, y, width, height, widgetTheme) -> {
            int points = 500;
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            float x0 = x;
            float w = (float)width / (float)points;
            for (int i = 0; i < points; ++i) {
                int color = Color.lerp(color1.getColor(), color2.getColor(), (float)i / (float)points);
                int r = Color.getRed(color);
                int g = Color.getGreen(color);
                int b = Color.getBlue(color);
                int a = 255;
                buffer.m_5483_((double)x0, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
                buffer.m_5483_((double)x0, (double)(y + height), 0.0).m_6122_(r, g, b, a).m_5752_();
                x0 += w;
            }
            tesselator.m_85914_();
        };
        ModularPanel panel = (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("colors").width(300)).coverChildrenHeight()).padding(7);
        IPanelHandler colorPicker1 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker1", color1::color, color1.getColor(), true).setDraggable(true).relative(panel)).top(0)).rightRel(1.0f), true);
        IPanelHandler colorPicker2 = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog("color_picker2", color2::color, color2.getColor(), true).setDraggable(true).relative(panel)).top(0)).leftRel(1.0f), true);
        return (ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().coverChildrenHeight()).child((IWidget)IKey.str("Colors sorted by luminance").asWidget().margin(1))).child((IWidget)((Widget)luminanceSortedColors.asWidget().widthRel(1.0f)).height(10))).child((IWidget)((TextWidget)IKey.str("Blending color").asWidget().margin(1)).marginTop(2))).child((IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("color picker button 1")).background(color1)).disableHoverBackground()).onMousePressed((mouseX, mouseY, mouseButton) -> {
            colorPicker1.openPanel();
            return true;
        }))).child(new CycleButtonWidget())).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().name("color picker button 2")).background(color2)).disableHoverBackground()).onMousePressed((mouseX, mouseY, mouseButton) -> {
            colorPicker2.openPanel();
            return true;
        })))).child((IWidget)IKey.str("OpenGL color gradient").asWidget().margin(1))).child((IWidget)((Widget)gradient.asWidget().widthRel(1.0f)).height(10))).child((IWidget)IKey.str("Gamma corrected gradient").asWidget().margin(1))).child((IWidget)((Widget)correctedGradient.asWidget().widthRel(1.0f)).height(10)));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    ItemStackHandler handler = new ItemStackHandler(4);
                    return LazyOptional.of(() -> handler).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }
}

